/* mbed simple H-bridge motor controller
 * Copyright (c) 2007-2010,
 *

 */

#include "TB6549.h"

#include "mbed.h"

Motor::Motor(PinName pwm, PinName in1, PinName in2,PinName sb):
    _pwm(pwm), _in1(in1), _in2(in2), _sb(sb)
{

    // Set initial condition of PWM
    _pwm.period(0.001);
    _pwm = 0;

    // Initial condition stand by
    _in1 = 0;
    _in2 = 0;
    _sb = 0;
}

void Motor::speed(float speed)
{
    if(speed > 0) {
        _in1=0;
        _in2=1;
        _sb=1;
    } else {
        _in1=1;
        _in2=0;
        _sb=1;
    }
    _pwm = abs(speed);
}
