#include "mbed.h"
#include "extra.h"

#define MARK 125  // 2000Hz 
#define SPACE 250    //1000Hz
#define BAUD 300
#define BIT_PERIOD_US 1/BAUD

//DigitalOut led(LED1);
PwmOut led(p21);
int output=0;
int buf_mod[10]={0};
int buf_index = 0;
Timeout stop;
Serial bt(p9, p10); // tx, rx


void stop_pwm(void);
void read_serial(void);
int main() {

    int i;
    pc.baud(115200);
    bt.baud(115200); 
    pc.attach(&read_serial);
    bt.attach(&read_serial); 
    timerSetup();
    int bit_index = 0;
    float period;
    state = IDLE;

    while (1) {


        if (output==0 && buf_mod[0] != 0) {
            if (!bit_index) {

                led=0.5;
                led.period_us(SPACE);
                //pc.printf("start bit\n");
                stop.attach_us(&stop_pwm,1000000*(float)BIT_PERIOD_US);
                bit_index++;
                output=1;
                continue;
            }
            period = ( 0x01 & (buf_mod[0] >> (bit_index-1)))? MARK:SPACE ;
            led = 0.5;
            pc.printf("Bit=%c", (period == MARK)?'H':'L' );

            led.period_us(period);
            stop.attach_us(&stop_pwm,1000000*(float)BIT_PERIOD_US);

            bit_index++;
            output = 1;

            //Transmission complete
            if (bit_index == 9) {

                bit_index = 0;
                buf_index--;
                i=0;
                led.period_us(MARK);
                //while (buf[i] != 0) {
                while (i <= buf_index) {
                    buf_mod[i] = buf_mod[i+1];
                    i++;
                }
                buf_mod[buf_index]=0;

            }
        }


        // DEMOD:
        if ( state == IDLE && n_long_periods == 3 ) {
            pc.printf("START ");
            state = READING;
            buf = 0;
            bit_count=0;
            n_long_periods = 0;
        } else if (state == READING ) {
            if (n_short_periods > 150 ) {
                // Error condition : You ve missed a bit
                state = IDLE;
                pc.printf("\n Error buf = %d",buf);
                buf = 0;
                bit_count = 0;
                continue;
            }

            if (n_short_periods == 90) {
                pc.printf("MARK ");
                buf = (0x80 | (buf >>1));
                bit_count++;


            }
            if (n_short_periods >100 ) {
                n_short_periods = 0;
            }

            if (n_long_periods == 4 ) {

                pc.printf("SPACE ");
                buf = buf >>1;
                bit_count++;
                n_long_periods=0;
            }

            if (bit_count == 8 ) {
                // all bits received
                pc.printf("\n Rx from UE = %c",buf);
                bt.putc(buf); 
                state = IDLE;
                buf = 0;
                bit_count=0 ;
            }
        }
    }
}
void read_serial(void) {

    if (pc.readable()) {

        buf_mod[buf_index++] = (int)pc.getc();
        //pc.printf("%d",buf[buf_index-1]);
        //buf[buf_index++]=171;
        buf_mod[buf_index]= 0;
    }
    if (bt.readable()) {

        buf_mod[buf_index++] = (int)bt.getc();
        //pc.printf("%d",buf[buf_index-1]);
        //buf[buf_index++]=171;
        buf_mod[buf_index]= 0;
    }
}
void stop_pwm(void) {
    output = 0;
    //led = 0;
}