#include "mbed.h"
 #include "mbed.h"
#include "arm_math.h"
#include "arm_const_structs.h"
#define SAMP_FREQ 2000
 
InterruptIn button(PC_13);
DigitalOut El(D2);
DigitalOut A(D3);
DigitalOut D(D4);
DigitalOut G(D5);
DigitalOut B(D6);
DigitalOut Eh(D7);
DigitalOut Led_Ok(D9);
DigitalOut Led_Down(D10);
DigitalOut Led_Up(D8);
Serial pc (SERIAL_TX,SERIAL_RX);
AnalogIn analog_value(A0);
const int FFT_LEN   = 1024;
const int bins      = 1000;

float Ing[FFT_LEN];

const static arm_cfft_instance_f32 *S;

float samples[FFT_LEN*2];
float magnitudes[FFT_LEN];
float freq_window[bins];

int c =0;
   void selectNote() {
            c++;
            if(c==1)
            {
                El=1;
                A=0;
                D=0;
                G=0;
                B=0;
                Eh=0;
            }
            else if(c==2)
            {
                El=0;
                A=1;
                D=0;
                G=0;
                B=0;
                Eh=0;
                
            }
            else if(c==3)
            {
                El=0;
                A=0;
                D=1;
                G=0;
                B=0;
                Eh=0;
                
            }
            
            else if(c==4)
            {
                El=0;
                A=0;
                D=0;
                G=1;
                B=0;
                Eh=0;
                
            }
            
            else if(c==5)
            {
                El=0;
                A=0;
                D=0;
                G=0;
                B=1;
                Eh=0;
                
            }
            
            else if(c==6)
            {
                El=0;
                A=0;
                D=0;
                G=0;
                B=0;
                Eh=1;
                
                
            }
            else if(c==7)
            c=0;
            
        }
int main() {
    El=0;
    A=0;
    D=0;
    G=0;
    B=0;
    Eh=0;
    
    El=1;wait(0.1);El=0;
    A=1;wait(0.1);A=0;
    D=1;wait(0.1);D=0;
    G=1;wait(0.1);G=0;
    B=1;wait(0.1);B=0;
    Eh=1;wait(0.1);Eh=0;
    El=1;A=1;D=1;G=1;B=1;Eh=1;wait(0.2);
    El=0;A=0;D=0;G=0;B=0;Eh=0;
    Led_Down=1;
    Led_Up=0;
    Led_Ok=0;
       
    
    
    int32_t i = 0;
    pc.printf("\r\n\r\nFFT test program!\r\n");


        // Init arm_ccft_32
    switch (FFT_LEN)
    {
    case 16:
        S = & arm_cfft_sR_f32_len16;
        break;
    case 32:
        S = & arm_cfft_sR_f32_len32;
        break;
    case 64:
        S = & arm_cfft_sR_f32_len64;
        break;
    case 128:
        S = & arm_cfft_sR_f32_len128;
        break;
    case 256:
        S = & arm_cfft_sR_f32_len256;
        break;
    case 512:
        S = & arm_cfft_sR_f32_len512;
        break;
    case 1024:
        S = & arm_cfft_sR_f32_len1024;
        break;
    case 2048:
        S = & arm_cfft_sR_f32_len2048;
        break;
    case 4096:
        S = & arm_cfft_sR_f32_len4096;
        break;
    }
    while(1) {
        button.rise(&selectNote);
        for (int k = 0; k < 1024; k++) {
            Ing[k] = (short) (analog_value.read_u16() - 0x8000);      
            wait_us(1e6/SAMP_FREQ);
            }
            //Riempiamo il vettore per la FFT
            for(i = 0; i< FFT_LEN*2; i+=2)
            {
    
               samples[i]      = Ing[i];
                samples[i+1]    = 0;
            }
               arm_cfft_f32(S, samples, 0, 1);
    // Calcola la FFT
    arm_cmplx_mag_f32(samples, magnitudes, FFT_LEN);
    
                   if(c==1){
                       int max=3;
                   int j=2;
                   do{
                        if (magnitudes[j]>magnitudes[max]&&(j*1000/1024<100)&&(j*1000/1024>30))//restringo la banda a [30Hz, 100Hz]
                        max=j;
                        j++;
                    
                       }while(j<1024/2);
                       
                        float maxx=(float)max*1000/1024;
                    
                       if(maxx<82){
                       Led_Down=1;
                       Led_Up=0;
                       Led_Ok=0;
                       }
                        if(maxx>84){
                       Led_Down=0;
                       Led_Up=1;
                       Led_Ok=0;
                       }
                       else if(maxx>82.3 &&maxx<=84){
                           Led_Down=0;
                       Led_Up=0;
                       Led_Ok=1;
                           }
                           }
                           //--------------A STRING------------------
                           if(c==2){
                               int max=3;
                   int j=2;
                   do{
                        
                        if (magnitudes[j]>magnitudes[max]&&(j*1000/1024<130)&&(j*1000/1024>90))//restringo la banda a [90Hz, 130Hz]
                        max=j;
                        j++;
                    
                       }while(j<1024/2);
                       
                        float maxx=(float)max*1000/1024;
                       //pc.printf("Il massimo in ampiezza è alla frequenza %f Hertz \n",(float)max*1000/1024);
                       if(maxx<110){
                       Led_Down=1;
                       Led_Up=0;
                       Led_Ok=0;
                       }
                        if(maxx>112){
                       Led_Down=0;
                       Led_Up=1;
                       Led_Ok=0;
                       }
                       else if(maxx>110 &&maxx<113){
                           Led_Down=0;
                       Led_Up=0;
                       Led_Ok=1;
                           }
                           }
                                  //--------------D STRING------------------
                           if(c==3){
                               int max=3;
                   int j=2;
                   do{
                        
                        if (magnitudes[j]>magnitudes[max]&&(j*1000/1024<160)&&(j*1000/1024>130))//restringo la banda a [130Hz, 160Hz]
                        max=j;
                        j++;
                    
                       }while(j<1024/2);
                       
                        float maxx=(float)max*1000/1024;
                       //pc.printf("Il massimo in ampiezza è alla frequenza %f Hertz \n",(float)max*1000/1024);
                       if(maxx<147){
                       Led_Down=1;
                       Led_Up=0;
                       Led_Ok=0;
                       }
                        if(maxx>149){
                       Led_Down=0;
                       Led_Up=1;
                       Led_Ok=0;
                       }
                       else if(maxx>147 &&maxx<149){
                           Led_Down=0;
                       Led_Up=0;
                       Led_Ok=1;
                           }
                           }
                                 //--------------G STRING------------------
                           if(c==4){
                               int max=3;
                   int j=2;
                   do{
                        
                        if (magnitudes[j]>magnitudes[max]&&(j*1000/1024<210)&&(j*1000/1024>170))//restringo la banda a [170Hz, 210Hz]
                        max=j;
                        j++;
                    
                       }while(j<1024/2);
                       
                        float maxx=(float)max*1000/1024;
                       //pc.printf("Il massimo in ampiezza è alla frequenza %f Hertz \n",(float)max*1000/1024);
                       if(maxx<196){
                       Led_Down=1;
                       Led_Up=0;
                       Led_Ok=0;
                       }
                        if(maxx>203){
                       Led_Down=0;
                       Led_Up=1;
                       Led_Ok=0;
                       }
                       else if(maxx>=196 &&maxx<=197.5){
                           Led_Down=0;
                       Led_Up=0;
                       Led_Ok=1;
                           }
                           }
                                 //--------------B STRING------------------
                           if(c==5){
                               int max=3;
                   int j=2;
                   do{
                        
                        if (magnitudes[j]>magnitudes[max]&&(j*1000/1024<260)&&(j*1000/1024>230))//restringo la banda a [230Hz, 260Hz]
                        max=j;
                        j++;
                    
                       }while(j<1024/2);
                       
                        float maxx=(float)max*1000/1024;
                       //pc.printf("Il massimo in ampiezza è alla frequenza %f Hertz \n",(float)max*1000/1024);
                       if(maxx<244){
                       Led_Down=1;
                       Led_Up=0;
                       Led_Ok=0;
                       }
                        if(maxx>250){
                       Led_Down=0;
                       Led_Up=1;
                       Led_Ok=0;
                       }
                       else if(maxx>246 &&maxx<250){
                           Led_Down=0;
                       Led_Up=0;
                       Led_Ok=1;
                           }
                           }
                                         //--------------Eh STRING------------------
                           if(c==6){
                               int max=3;
                   int j=2;
                   do{
                        
                        if (magnitudes[j]>magnitudes[max]&&(j*1000/1024<340)&&(j*1000/1024>310))//restringo la banda a [340Hz, 310Hz]
                        max=j;
                        j++;
                    
                       }while(j<1024/2);
                       
                        float maxx=(float)max*1000/1024;
                       //pc.printf("Il massimo in ampiezza è alla frequenza %f Hertz \n",(float)max*1000/1024);
                       if(maxx<327){
                       Led_Down=1;
                       Led_Up=0;
                       Led_Ok=0;
                       }
                        if(maxx>334){
                       Led_Down=0;
                       Led_Up=1;
                       Led_Ok=0;
                       }
                       else if(maxx>330.3 &&maxx<333.5){
                           Led_Down=0;
                       Led_Up=0;
                       Led_Ok=1;
                           }
                           }
                           
                       
    }
}

