/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "BufferedSerial.h"
#include "platform/mbed_thread.h"

BufferedSerial      pc(USBTX, USBRX,115200);    //Serial port for debug
BufferedSerial      COM2(PC_12, PD_2,115200);    //Serial port COM2


DigitalInOut MYPIO_0(PA_9); //D8
DigitalInOut MYPIO_1(PC_7); //D9
DigitalInOut MYPIO_2(PB_6); //D10
DigitalInOut MYPIO_3(PA_7); //D11
DigitalInOut MYPIO_4(PA_6); //D12

DigitalOut  LED_FAB(PB_5);
DigitalOut  GREEN_LED(PA_5);
DigitalIn   WATER_DETECT(PB_1); //water detect   0=ok  1=Water

AnalogIn Analog_0(PA_0);
AnalogIn Analog_1(PA_1);
char strAdc[10];

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

char cmdParams[10][10];
unsigned char cmdParamsCount = 0;


/* Helper function for printing floats & doubles */
static char *print_double(char *str, double v, int decimalDigits = 2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;
    uint8_t fracSign = 0; //0 = negativo 1=positivo
    
    if(v<0){ fracSign = 0; }
    else{ fracSign=1; }


    /* prepare decimal digits multiplicator */
    for (; decimalDigits != 0; i *= 10, decimalDigits--);

    /* calculate integer & fractinal parts */
    intPart = abs((int)v);
    fractPart = (int)((v - (double)(int)v) * i);
    fractPart = abs(fractPart);

    /* fill in integer part */
    if(fracSign == 0){ sprintf(str, "-%i.", intPart); }
    else{     sprintf(str, "%i.", intPart); }


    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];

    /* fill in leading fractional zeros */
    for (i /= 10; i > 1; i /= 10, ptr++) {
        if (fractPart >= i) {
            break;
        }
        *ptr = '0';
    }

    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);

    return str;
}


unsigned char splitString(char *textToSplit,const char *delimiter)
{
    cmdParamsCount = 0;
    char * token = strtok(textToSplit,delimiter);
    
    
    while(token != NULL)
    {
        sprintf(cmdParams[cmdParamsCount],"%s",token);    
        token = strtok(NULL, delimiter);
        cmdParamsCount++;
    }
    
    return cmdParamsCount;
}

bool startsWith(const char *pre, const char *str)
{
    size_t lenpre = strlen(pre),
           lenstr = strlen(str);
    return lenstr < lenpre ? false : memcmp(pre, str, lenpre) == 0;
}


char outBuffer[255];
char inBuffer[255] = "";
char inChar[1];
char gpio_map[6] = "00000";
void execute_com1_cmd()
{
    inBuffer[strlen(inBuffer)-1] = 0;
         if(startsWith("SET GPIO1_IN",inBuffer)){ MYPIO_0.input(); gpio_map[0] = '1'; }
    else if(startsWith("SET GPIO2_IN",inBuffer)){ MYPIO_1.input(); gpio_map[1] = '1';}
    else if(startsWith("SET GPIO3_IN",inBuffer)){ MYPIO_2.input(); gpio_map[2] = '1';}
    else if(startsWith("SET GPIO4_IN",inBuffer)){ MYPIO_3.input(); gpio_map[3] = '1';}
    else if(startsWith("SET GPIO5_IN",inBuffer)){ MYPIO_4.input(); gpio_map[4] = '1';}
    else if(startsWith("SET GPIO1_OUT",inBuffer)){ MYPIO_0.output(); gpio_map[0] = '0';}
    else if(startsWith("SET GPIO2_OUT",inBuffer)){ MYPIO_1.output(); gpio_map[1] = '0';}
    else if(startsWith("SET GPIO3_OUT",inBuffer)){ MYPIO_2.output(); gpio_map[2] = '0';}
    else if(startsWith("SET GPIO4_OUT",inBuffer)){ MYPIO_3.output(); gpio_map[3] = '0';}
    else if(startsWith("SET GPIO5_OUT",inBuffer)){ MYPIO_4.output(); gpio_map[4] = '0';}
    else if(startsWith("SET GPIO1 1",inBuffer)){ MYPIO_0.write(1); }
    else if(startsWith("SET GPIO1 0",inBuffer)){ MYPIO_0.write(0); }
    else if(startsWith("SET GPIO2 1",inBuffer)){ MYPIO_1.write(1); }
    else if(startsWith("SET GPIO2 0",inBuffer)){ MYPIO_1.write(0); }
    else if(startsWith("SET GPIO3 1",inBuffer)){ MYPIO_2.write(1); }
    else if(startsWith("SET GPIO3 0",inBuffer)){ MYPIO_2.write(0); }
    else if(startsWith("SET GPIO4 1",inBuffer)){ MYPIO_3.write(1); }
    else if(startsWith("SET GPIO4 0",inBuffer)){ MYPIO_3.write(0); }    
    else if(startsWith("SET GPIO5 1",inBuffer)){ MYPIO_4.write(1); }
    else if(startsWith("SET GPIO5 0",inBuffer)){ MYPIO_4.write(0); }    
    else if(startsWith("GET GPIO1",inBuffer)){ sprintf(outBuffer,"%d\r\n",MYPIO_0.read()); pc.write(outBuffer,strlen(outBuffer)); }
    else if(startsWith("GET GPIO2",inBuffer)){ sprintf(outBuffer,"%d\r\n",MYPIO_1.read()); pc.write(outBuffer,strlen(outBuffer)); }
    else if(startsWith("GET GPIO3",inBuffer)){ sprintf(outBuffer,"%d\r\n",MYPIO_2.read()); pc.write(outBuffer,strlen(outBuffer)); }
    else if(startsWith("GET GPIO4",inBuffer)){ sprintf(outBuffer,"%d\r\n",MYPIO_3.read()); pc.write(outBuffer,strlen(outBuffer)); }
    else if(startsWith("GET GPIO5",inBuffer)){ sprintf(outBuffer,"%d\r\n",MYPIO_4.read()); pc.write(outBuffer,strlen(outBuffer)); }
    else if(startsWith("GET GPIO_MAP",inBuffer)){ sprintf(outBuffer,"%s\r\n",gpio_map); pc.write(outBuffer,strlen(outBuffer)); } 
    else if(startsWith("GET ADC0",inBuffer)){ sprintf(outBuffer,"%s\r\n",print_double(strAdc,Analog_0*3.3,4)); pc.write(outBuffer,strlen(outBuffer)); }
    else if(startsWith("GET ADC1",inBuffer)){ sprintf(outBuffer,"%s\r\n",print_double(strAdc,Analog_1*3.3,4)); pc.write(outBuffer,strlen(outBuffer));}
    else if(startsWith("SET LED 1",inBuffer)){ LED_FAB.write(1); }    
    else if(startsWith("SET LED 0",inBuffer)){ LED_FAB.write(0); } 
}



int main()
{
    // Initialise the digital pin LED1 as an output
    MYPIO_0.output();   MYPIO_0 = 0;
    MYPIO_1.output();   MYPIO_1 = 0;
    MYPIO_2.output();   MYPIO_2 = 0;
    MYPIO_3.output();   MYPIO_3 = 0;
    MYPIO_4.output();   MYPIO_4 = 0;
    LED_FAB = 1;
    while (true) {
        //led = !led;
        /*
        while(pc.readable())
        {
            pc.read(inChar,1);
            if(inChar[0] == '\n')
            {
                execute_com1_cmd();
                sprintf(inBuffer,"");
            }
            else{
                sprintf(inBuffer,"%s%c",inBuffer,inChar[0]);
            }
            //pc.write(inBuffer,strlen(inBuffer));
        }
        */
        thread_sleep_for(1000);
        LED_FAB = !LED_FAB;
        GREEN_LED =!GREEN_LED;
    }
}
