/*
 *  ======== INA237.c ========
 *  INA237 APIs for initialization and use of the INA237 peripheral
 *
 *  DO NOT EDIT - This file is generated by the SysConfig tool for
 *  the TI Sensors in this application.
 */

#include <stddef.h>
#include <stdint.h>

#include "INA237.h"
//#include "mcu.h"


#define INA237_0_config_register_VALUE (INA237_config_register_rst_NormalOperation | \
                                        0x0000U | \
                                        INA237_config_register_tempcomp_Shunttemperaturecompensationdisabled | \
                                        INA237_config_register_adcrange_16384mV)
#define INA237_0_adc_config_register_VALUE (INA237_adc_config_register_mode_Continuousbusvoltageshuntvoltageandtemperature | \
                                            INA237_adc_config_register_vbusct_1052us | \
                                            INA237_adc_config_register_vshct_1052us | \
                                            INA237_adc_config_register_vtct_1052us | \
                                            INA237_adc_config_register_avg_1)
#define INA237_0_shunt_cal_register_VALUE 0x0000U
#define INA237_0_diag_alrt_register_VALUE (INA237_diag_alrt_register_alrlen_Transparent | \
                                           INA237_diag_alrt_register_cnvr_DisableconversionreadyflagonALERTpin | \
                                           INA237_diag_alrt_register_slwalrt_ALERTcomparisononnonaveragedADCvalue | \
                                           INA237_diag_alrt_register_apol_Normalactivelowopendrain)
#define INA237_0_sovl_register_VALUE 0x7FFFU
#define INA237_0_suvl_register_VALUE 0x8000U
#define INA237_0_bovl_register_VALUE 0x7FFFU
#define INA237_0_buvl_register_VALUE 0x0000U
#define INA237_0_temp_limit_register_VALUE 0x7FF0U
#define INA237_0_pwr_limit_register_VALUE 0xFFFFU

static INA237_State INA237_0_state = {
    /* Configuration and Settings */
    .config = INA237_0_config_register_VALUE,
    .adcconfig = INA237_0_adc_config_register_VALUE,
    .shuntcal = INA237_0_shunt_cal_register_VALUE,
    .diagalrt = INA237_0_diag_alrt_register_VALUE,
    .sovl = INA237_0_sovl_register_VALUE,
    .suvl = INA237_0_suvl_register_VALUE,
    .bovl = INA237_0_bovl_register_VALUE,
    .buvl = INA237_0_buvl_register_VALUE,
    .templimit = INA237_0_temp_limit_register_VALUE,
    .pwrlimit = INA237_0_pwr_limit_register_VALUE,

    .adcrange = INA237_0_config_register_VALUE & INA237_config_register_adcrange_4096mV,
    .currentlsb = 0,

    /* Sensor's I2C bus ID and address */
    .busId = 0,
    .devAddr = 0x40U,

};
const INA237_Handle INA237_0 = &INA237_0_state;



#define MSB(u16) (((u16) & 0xFF00U) >> 8)
#define LSB(u16) ((u16) & 0xFFU)

#define maxRegAddress 0x3F

// Register size in bytes
const uint8_t INA237_regSize[maxRegAddress+1] = {
                                            2,2,2,2,2,2,2,2,\
                                            3,2,2,2,2,2,2,2,\
                                            2,2,0,0,0,0,0,0,\
                                            0,0,0,0,0,0,0,0,\
                                            0,0,0,0,0,0,0,0,\
                                            0,0,0,0,0,0,0,0,\
                                            0,0,0,0,0,0,0,0,\
                                            0,0,0,0,0,0,2,2
};

void mcu_i2cInit(uint8_t busId);
int8_t mcu_i2cTransfer(uint8_t busId, uint8_t sensorAddress,
                              uint8_t *dataToWrite, uint8_t writeLength,
                              uint8_t *dataToRead,  uint8_t readLength);
void mcu_msWait(unsigned long msWait);                              

/*
 *  ======== INA237_writeReg ========
 * Write register
 */
void INA237_writeReg(INA237_Handle sensor, uint8_t regAddr, uint16_t value)
{
    uint8_t txBuf[3] = {0}; //All writable registers are 2 bytes

    txBuf[0] = regAddr;
    txBuf[1] = MSB(value);
    txBuf[2] = LSB(value);
    mcu_i2cTransfer(sensor->busId, sensor->devAddr, txBuf, 3, NULL, 0);

    //check for change in ADCRANGE 
    if(regAddr == INA237_vshunt_register)
    {
        sensor->adcrange = value & INA237_config_register_adcrange_4096mV;
    }
}

/*
 *  ======== INA237_config ========
 * Configure device with current settings.
 */
void INA237_config(INA237_Handle sensor)
{
    //Initialize the bus containing this sensor
    mcu_i2cInit(sensor->busId);

    //Write sensor Configuration Register
   INA237_writeReg(sensor, INA237_config_register, sensor->config);
   INA237_writeReg(sensor, INA237_adc_config_register, sensor->adcconfig);
   INA237_writeReg(sensor, INA237_shunt_cal_register, sensor->shuntcal);
   INA237_writeReg(sensor, INA237_diag_alrt_register, sensor->diagalrt);
   INA237_writeReg(sensor, INA237_sovl_register, sensor->sovl);
   INA237_writeReg(sensor, INA237_suvl_register, sensor->suvl);
   INA237_writeReg(sensor, INA237_bovl_register, sensor->bovl);
   INA237_writeReg(sensor, INA237_buvl_register, sensor->buvl);
   INA237_writeReg(sensor, INA237_temp_limit_register, sensor->templimit);
   INA237_writeReg(sensor, INA237_pwr_limit_register, sensor->pwrlimit);
}

/*
 *  ======== INA237_setCURRENT_LSB ========
 *  Set the CURRENT_LSB value used for calculations
 */
void INA237_setCURRENT_LSB(INA237_Handle sensor, float CURRENT_LSB)
{
    sensor->currentlsb = CURRENT_LSB;
}

/*
 *  ======== INA237_readReg ========
 *  Read register
 */
uint64_t INA237_readReg(INA237_Handle sensor, uint8_t regAddr)
{
    uint64_t value;
    int i;
    
    uint8_t txBuf[1] = {0};
    uint8_t rxBuf[5] = {0}; //max buffer size

    txBuf[0] = regAddr;

    //Read register
    mcu_i2cTransfer(sensor->busId, sensor->devAddr, txBuf, 1, rxBuf, INA237_regSize[regAddr]);

    //Combine bytes
    value = rxBuf[0];
    for(i = 1; i < INA237_regSize[regAddr]; i++)
    {
        value = (value << 8) | rxBuf[i];
    }

    return value;
}

/*
 *  ======== INA237_getVSHUNT_mV ========
 *  Get VSHUNT value (mV)
 */
float INA237_getVSHUNT_mV(INA237_Handle sensor)
{
    uint64_t value = INA237_readReg(sensor, INA237_vshunt_register);
    float data;

    //Convert for 2's compliment and signed value
    if(value > 0x7FFF)
    {
        data = (float)value - 0x10000;
    }
    else
    {
        data = (float)value;
    }

    //Convert to mV

    if(sensor->adcrange == INA237_config_register_adcrange_4096mV)
    {
        data = (data * 1.25) / 1000;
    }
    else
    {
        data = (data * 5) / 1000;
    }

    return data;
}

/*
 *  ======== INA237_getVBUS_V ========
 *  Get VBUS value (V)
 */
float INA237_getVBUS_V(INA237_Handle sensor)
{
    uint64_t value = INA237_readReg(sensor, INA237_vbus_register);
    float data;

    //Convert for 2's compliment and signed value (though always positive)
    if(value > 0x7FFF)
    {
        data = (float)value - 0x10000; //left for redundancy and error checking, should never get used
    }
    else
    {
        data = (float)value;
    }

    //Convert to V
    data = (data * 3.125) / 1000;

    return data;
}

/*
 *  ======== INA237_getDIETEMP_C ========
 *  Get DIETMEP value (C)
 */
float INA237_getDIETEMP_C(INA237_Handle sensor)
{
    uint64_t value = INA237_readReg(sensor, INA237_dietemp_register);
    float data;

    //Remove reserved bits
    value = value >> 4;

    //Convert for 2's compliment and signed value
    if(value > 0x7FF)
    {
        data = (float)value - 0x1000; 
    }
    else
    {
        data = (float)value;
    }

    //Convert to C
    data = (data * 125) / 1000;

    return data;
}

/*
 *  ======== INA237_getDIETEMP_F ========
 *  Get DIETMEP value (F)
 */
float INA237_getDIETEMP_F(INA237_Handle sensor)
{
    float data = INA237_getDIETEMP_C(sensor);
    
    //Convert to F
    data = (data * (9/5)) + 32;

    return data;
}

/*
 *  ======== INA237_getCURRENT_signedLSB ========
 *  Get CURRENT value (signed value in LSBs)
 */
float INA237_getCURRENT_signedLSB(INA237_Handle sensor)
{
    uint64_t value = INA237_readReg(sensor, INA237_current_register);
    float data;

    //Convert for 2's compliment and signed value 
    if(value > 0x7FFF)
    {
        data = (float)value - 0x10000;
    }
    else
    {
        data = (float)value;
    }

    return data;
}

/*
 *  ======== INA237_getCURRENT_A ========
 *  Get CURRENT value (A)
 */
float INA237_getCURRENT_A(INA237_Handle sensor)
{
    float data = INA237_getCURRENT_signedLSB(sensor);

    data = data * sensor->currentlsb;

    return data;
}

/*
 *  ======== INA237_getPOWER_signedLSB ========
 *  Get POWER value (signed value in LSBs)
 */
float INA237_getPOWER_signedLSB(INA237_Handle sensor)
{
    uint64_t value = INA237_readReg(sensor, INA237_power_register);
    float data;

    data = (float)value;

    return data;
}

/*
 *  ======== INA237_getPOWER_W ========
 *  Get POWER value (W)
 */
float INA237_getPOWER_W(INA237_Handle sensor)
{
    float data = INA237_getPOWER_signedLSB(sensor);

    data = data * sensor->currentlsb * 0.2;

    return data;
}

void mcu_i2cInit(uint8_t busId)
{
    /* Add MCU specific init necessary for I2C to be used */
}

int8_t mcu_i2cTransfer( uint8_t busId, uint8_t i2cAddr,
                        uint8_t *dataToWrite, uint8_t writeLength,
                        uint8_t *dataToRead,  uint8_t readLength)
{
    /*
     *  Add MCU specific I2C read/write code here.
     */

    /*
     *  Add MCU specific return code for error handling
     */

    return (0);
}
/********* MCU SPECIFIC I2C CODE ENDS HERE**********/




/********* MCU SPECIFIC DELAY CODE STARTS HERE************/
void mcu_msWait(unsigned long msWait)
{
    /*
     *  Add MCU specific wait loop for msWait. The unit is in milli-seconds
     */
}