#ifndef LIS3MDL_h
#define LIS3MDL_h

#include "mbed.h"
#include "vector.h"

#define LIS3MDL_PI             3.1415926535897932384626433832795
#define LIS3MDL_Rad2Degree     57.295779513082320876798154814105

//Registers
#define LIS3MDL_WHO_AM_I        0x0F
#define LIS3MDL_CTRL_REG1       0x20
#define LIS3MDL_CTRL_REG2       0x21
#define LIS3MDL_CTRL_REG3       0x22
#define LIS3MDL_CTRL_REG4       0x23
#define LIS3MDL_CTRL_REG5       0x24
#define LIS3MDL_STATUS_REG      0x27
#define LIS3MDL_OUT_X_L         0x28
#define LIS3MDL_OUT_X_H         0x29
#define LIS3MDL_OUT_Y_L         0x2A
#define LIS3MDL_OUT_Y_H         0x2B
#define LIS3MDL_OUT_Z_L         0x2C
#define LIS3MDL_OUT_Z_H         0x2D
#define LIS3MDL_TEMP_OUT_L      0x2E
#define LIS3MDL_TEMP_OUT_H      0x2F
#define LIS3MDL_INT_CFG         0x30
#define LIS3MDL_INT_SRC         0x31
#define LIS3MDL_INT_THS_L       0x32
#define LIS3MDL_INT_THS_H       0x33

#define LIS3MDL_ADDRESS         0x3C

//Register Masks

//WHO_AM_I masks
#define LIS3MDL_I_AM_MASK       0x3D

// CTRL_REG1 masks
#define LIS3MDL_TEMP_EN_MASK    0xF0
#define LIS3MDL_OM_MASK         0x06
#define LIS3MDL_DO_MASK         0x1C
#define LIS3MDL_ST_MASK         0x01

// CTRL_REG2 masks
#define LIS3MDL_FS_MASK         0x60
#define LIS3MDL_REBOOT_MASK     0x08
#define LIS3MDL_SOFT_RST_MASK   0x04

// CTRL_REG3 masks
#define LIS3MDL_LP_MASK         0x20
#define LIS3MDL_SIM_MASK        0x04
#define LIS3MDL_MD_MASK         0x03

// CTRL_REG4 masks
#define LIS3MDL_OMZ_MASK        0x0C
#define LIS3MDL_BLE_MASK        0x02

// CTRL_REG5 masks
#define LIS3MDL_BDU_MASK        0x40

// STATUS_REG masks
#define LIS3MDL_ZYXOR_MASK      0x80
#define LIS3MDL_ZOR_MASK        0x40
#define LIS3MDL_YOR_MASK        0x20
#define LIS3MDL_XOR_MASK        0x10
#define LIS3MDL_ZYXDA_MASK      0x08
#define LIS3MDL_ZDA_MASK        0x04
#define LIS3MDL_YDA_MASK        0x02
#define LIS3MDL_XDA_MASK        0x01

// INT_CFG masks
#define LIS3MDL_XIEN_MASK       0x80
#define LIS3MDL_YIEN_MASK       0x40
#define LIS3MDL_ZIEN_MASK       0x20
#define LIS3MDL_IEA_MASK        0x04
#define LIS3MDL_LIR_MASK        0x02
#define LIS3MDL_IEN_MASK        0x01

// INT_SRC masks
#define LIS3MDL_PTH_X_MASK      0x80
#define LIS3MDL_PTH_Y_MASK      0x40
#define LIS3MDL_PTH_Z_MASK      0x20
#define LIS3MDL_NTH_X_MASK      0x01
#define LIS3MDL_NTH_Y_MASK      0x08
#define LIS3MDL_NTH_Z_MASK      0x04
#define LIS3MDL_MROI_MASK       0x02
#define LIS3MDL_INT_MASK        0x01

// INT_THS_L masks
#define LIS3MDL_THS_L_MASK      0xFF

// INT_THS_H masks
#define LIS3MDL_THS_H_MASK      0x7F

//typedef enum { false, true } bool;

class LIS3MDL
{  
    /*
    public:
    template <typename T> struct vector
    {
      T x, y, z;
    };
    */
    public:
    /*CONSTRUCTOR:
     * Create itself the i2c serial line
     */
    LIS3MDL(PinName sda, PinName scl);
    bool init(void);

        int16_t getAxisX(void);
        int16_t getAxisY(void);
        int16_t getAxisZ(void);
        
        float getAxisX_mag();
        float getAxisY_mag();
        float getHeading();
        
        int16_t getTemperature(void);
        void getMag(int16_t* ax, int16_t* ay, int16_t* az);

        bool whoAmI(void);

        

    private:
        I2C i2c;
        int i2c_write(uint8_t DeviceAddr, uint8_t RegisterAddr,uint8_t value, uint16_t NumByteToWrite);
        int i2c_read(uint8_t DeviceAddr, uint8_t RegisterAddr, uint8_t* pBuffer, uint16_t NumByteToRead);
        bool writeRegister(const uint8_t register_addr, const uint8_t value);
        bool writeRegisters(const uint8_t msb_register, const uint8_t msb_value, const uint8_t lsb_register, const uint8_t lsb_value);
        bool writeMaskedRegister(const uint8_t register_addr, const uint8_t mask, const bool value);
        bool writeMaskedRegister(const int register_addr, const int mask, const int value);
        uint8_t readRegister(const uint8_t register_addr);
        uint16_t readRegisters(const uint8_t msb_register, const uint8_t lsb_register);
        uint8_t readMaskedRegister(const uint8_t register_addr, const uint8_t mask);

        uint8_t _address;
        uint8_t _whoami;
};



#endif



