/* mbed Wiegand Library
 * Copyright (c) 2017-2019, Gregorio Marquez
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "mbed.h"
#include "wiegand.h"

Serial serial(USBTX, USBRX);
Thread wiegandThread;
EventQueue* queue = new EventQueue (16*EVENTS_EVENT_SIZE);

class wiegandUserApp{
private:
    Wiegand* w1;
    Wiegand* w2;
    Wiegand* w3;
    Wiegand* w4;
    unsigned short int _bits;
    void _onTag(Wiegand* wiegandReader){
        long double rawInt = wiegandReader->getRawInt();
        unsigned char id = wiegandReader->getId();
        serial.printf("id: %d\r\n",id);
        serial.printf("Integer: %.0Lf\r\n",rawInt);
        
        unsigned char decDigits = wiegandReader->getDecDigits();
        volatile char* decimalString = new volatile char [decDigits+1];
        memset((char*)decimalString,'\0',decDigits+1);
        wiegandReader->getDecString(decimalString);
        serial.printf("Decimal String:      %s\r\n",decimalString);
        delete[] decimalString;

        unsigned char hexDigits = wiegandReader->getHexDigits();
        volatile char* hexadecimalString = new volatile char [hexDigits+1];
        memset((char*)hexadecimalString,'\0',hexDigits+1);
        wiegandReader->getHexString(hexadecimalString);
        serial.printf("Hexadecimal String:  %s\r\n\n",hexadecimalString);
        delete[] hexadecimalString;

        wiegandReader->reset();
    }
public:
    wiegandUserApp(EventQueue* eventQueue,PinName p1d0, PinName p1d1,PinName p2d0, PinName p2d1, PinName p3d0, PinName p3d1, PinName p4d0, PinName p4d1){   
        w1 = new Wiegand (p1d0, p1d1, eventQueue,1);
        w2 = new Wiegand (p2d0, p2d1, eventQueue,2);
        w3 = new Wiegand (p3d0, p3d1, eventQueue,3);
        w4 = new Wiegand (p4d0, p4d1, eventQueue,4);
    };
    void init(){
        w1->setBits(_bits);
        w2->setBits(_bits);
        w3->setBits(_bits);
        w4->setBits(_bits);
        w1->attach(callback(this,&wiegandUserApp::_onTag));
        w2->attach(callback(this,&wiegandUserApp::_onTag));
        w3->attach(callback(this,&wiegandUserApp::_onTag));
        w4->attach(callback(this,&wiegandUserApp::_onTag));
    }
    void setBits(unsigned short int bits){
        _bits= bits;
    }
};

PinName P1D0 = PE_0;
PinName P1D1 = PE_2;
PinName P2D0 = D4;
PinName P2D1 = D5;
PinName P3D0 = D6;
PinName P3D1 = D7;
PinName P4D0 = D8;
PinName P4D1 = D9;

int main(){
    serial.printf("\r\n******************* Wiegand reader example *******************\r\n\n");
    wiegandThread.start(callback(queue,&EventQueue::dispatch_forever));
    wiegandUserApp wiegandApp(queue,P1D0,P1D1,P2D0,P2D1,P3D0,P3D1,P4D0,P4D1);
    wiegandApp.setBits(32);
    wiegandApp.init();
}