#ifndef EXPONENTIAL_AVERAGE_H
#define EXPONENTIAL_AVERAGE_H

#define ALPHA .8

class ExponentialAverage
{
    public :
        explicit ExponentialAverage()
        {   
            reset();
        }
        
        float add(float reading)
        {
            avg = (ALPHA * reading) + (1.0 - ALPHA) * avg;   
            
            return avg;
        }
        
        float average()
        {
            return avg;
        }
        
        void reset()
        {
            avg = 0;
        }
    
    private:
        float avg;    
};

ExponentialAverage rightExpAvg;
ExponentialAverage leftExpAvg;
ExponentialAverage frontExpAvg;

#endif