#ifndef FLOODING_H
#define FLOODING_H


#include "Mapping.h"

enum MOVE
{
    M_NORTH, 
    M_SOUTH, 
    M_EAST, 
    M_WEST, 
    M_INVALID
};

unsigned char destX = 8;
unsigned char destY = 8;
unsigned char pathX = 8;
unsigned char pathY = 8;


unsigned char flood[16][16] = 
{
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
};

void clearFlood()
{
    for(unsigned char i = 0; i < (unsigned char)16; i++)
        for(unsigned char j = 0; j < (unsigned char)16; j++)
            flood[i][j] = 0x00; 
}

bool flood_getTop(int i, int j)
{
    if(validDimen(i, j) && flood[i][j] == 0)
        return !((MAP[i + 1][j] & TOP) == TOP || ((MAP[i][j] & BOTTOM) == BOTTOM));
    
    return false;
}

bool flood_getRight(int i, int j)
{
    if(validDimen(i, j) && flood[i][j] == 0)
        return !((MAP[i][j - 1] & RIGHT) == RIGHT || ((MAP[i][j] & LEFT) == LEFT));
    
    return false;
}

bool flood_getLeft(int i, int j)
{
    if(validDimen(i, j) && flood[i][j] == 0)
        return !((MAP[i][j + 1] & LEFT) == LEFT || ((MAP[i][j] & RIGHT) == RIGHT));
    
    return false;
}

bool flood_getBottom(int i, int j)
{
    if(validDimen(i, j) && flood[i][j] == 0)
        return !((MAP[i - 1][j] & BOTTOM) == BOTTOM || ((MAP[i][j] & TOP) == TOP));
    
    return false;
}

int flood_getCell(int i, int j)
{
    if(validDimen(i, j))
        return flood[i][j];
    
    return 0;
}

void flood_floodStep(int step)
{
    for(int i = 4; i >= 0 ; i--)
    {
        for(int j = 0; j < 5; j++)
        {
            if(flood[i][j] == step)
            {
                if(flood_getTop(i - 1, j))
                {
                    flood[i - 1][j] = (char) (step + 1);
                }
                
                if(flood_getBottom(i + 1, j))
                {
                    flood[i + 1][j] = (char) (step + 1);
                }
                
                if(flood_getLeft(i, j - 1))
                {
                    flood[i][j - 1] = (char) (step + 1);
                }
                if(flood_getRight(i, j + 1))
                {
                    flood[i][j + 1] = (char) (step + 1);
                }
            }
        }
    }
}

MOVE flood_bestMove(int x, int y)
{
    int target = flood_getCell(x, y) - 1;
    
    if(flood_getCell(x + 1, y) == target && ((MAP[x + 1][y] & TOP) != TOP))
    {
        pathX++;
        return M_NORTH;
    }
    if(flood_getCell(x, y - 1) == target && ((MAP[x][y - 1] & RIGHT) != RIGHT))
    {
        pathY--;
        return M_EAST;
    }
    
    if(flood_getCell(x, y + 1) == target && ((MAP[x][y + 1] & LEFT) != LEFT))
    {
        pathY++;
        return M_WEST;
    }
    if(flood_getCell(x - 1, y) == target && ((MAP[x - 1][y] & BOTTOM) != BOTTOM))
    {
        pathX--;
        return M_SOUTH;
    }
    
    return M_INVALID;
}

MOVE flood_findPath(int xt, int yt)
{
    flood[xt][yt] = 1;

    int step = 1;
    while(flood[destX][destY] == 0)
    {
        flood_floodStep(step++);
    }
    
    MOVE last = M_INVALID;
    
    while (flood_getCell(pathX, pathY) != 1)
    {
        last = flood_bestMove(pathX, pathY);
    } 
    
    return last;
}

#endif