#ifndef BUFFER_AVERAGE_H
#define BUFFER_AVERAGE_H

#include "Communication.h"

// A buffer size of 128 updated every 4ms or so gives us and average for the last half second. 
#define BUFFER_SIZE 128
class BufferAverage
{
    public: 
        explicit BufferAverage()
        {
            reset();
        }
        
        void reset()
        {
            ptr = 0;
            total = 0;
            for(int i = 0; i < BUFFER_SIZE; i++)
                buff[i] = 0.0f;
        }
        
        void add(float reading)
        {
            WIRELESS.printf("%i \n\r", (int)(ptr % BUFFER_SIZE));
            total -= buff[ptr % BUFFER_SIZE];
            total += reading;
            buff[ptr++] = reading;
        }
        
        float average()
        {
            return total / (BUFFER_SIZE > ptr ? BUFFER_SIZE : ptr); //min(BUFFER_SIZE, ptr);   
        }
    
    private:
        unsigned long ptr;
        float total;
        float buff [BUFFER_SIZE];
};

BufferAverage leftBufferAvg;
BufferAverage rightBufferAvg;
BufferAverage frontBufferAvg;
#endif