


#include "mbed.h" 
#include "string.h"
 
// pin config
Serial GSM(p13,p14);
Serial pc(USBTX, USBRX);
Timer t;
InterruptIn power(p10);
DigitalOut relay(p9);
DigitalIn pwr(p22);

//functions
int  read_GSM();
void GSM_init();
void sms_init();
void send_sms(char* text);
void retrieve_sms();
void msg_parse();
void manage();
void action(int,int);
void wait_msg();

//global variables
char comm[100];
char num[15]="+917829697914";
int time1;
int msg[100];
int numb[20];
int log1[20];
int dm;


int main() 
{ 
    power.fall(&manage);
    GSM_init();
    sms_init();
    while(1)
    {
    //test msg
    while(GSM.readable())
    GSM.getc();
    wait_msg();
    retrieve_sms();
    msg_parse();
     }
     
    }
    
int read_GSM()
{
  int i=0;
  while(1)
       { 
         comm[i]=GSM.getc();
         if(comm[i]==10 && comm[i-1]==13 && comm[i-2]==75 && comm[i-3]==79)
         {
         return i;
         }
         pc.putc(comm[i]);
         i++; }
  
}

void send_sms(char* text)
{
 GSM.printf("AT+CMGS=\"%s\"\r%s!%c",num,text,26);
}

void GSM_init()
{  
  // check if GSM is fine
    GSM.printf("AT\r");                     
    dm=read_GSM();
    //pc.printf("%s",comm);
    //if(strcmp("OK",comm)==0)
    pc.printf("GSM Working fine\n");
    wait(1);
    
    //no echo
    GSM.printf("ATE0\r");
    dm=read_GSM();
    pc.printf("Echo Switched off\n");
    wait(1);
    
    //network reg
    GSM.printf("AT+CREG?\r");
    dm=read_GSM();
    pc.printf("Network Registered\n"); 
    wait(1);
    //Service provider
    pc.printf("\n Network Provider\n"); 
    GSM.printf("AT+CGMI\r");
    dm=read_GSM();
    wait(1);
 }
 
 void sms_init()
 {
  GSM.printf("AT+CMGF=1\r");
  dm=read_GSM();
  pc.printf("GSM SMS set to Text Mode\n");
  wait(0.5);
  //delete all previous messages  
  GSM.printf("AT+CMGD=1,4\r");
  read_GSM();
  pc.printf("All previous messages cleared");
 }
 
 void retrieve_sms()
 { GSM.printf("AT+CMGR=1\r");
    int i=0;
    while(1)
    {
     comm[i]=GSM.getc();
     if(comm[i]==10 && comm[i-1]==13 && comm[i-2]==75 && comm[i-3]==79)
     break;
     i++;
     }
   int len=i; 
   int j=0;
   // Get message
   for(i=len-8;i>0;i--)
   if(comm[i]==13 && comm[i+1]==10)
   break;
   pc.printf("Message retrieved is: ");
   int k=0;
   for(j=i+2;j<=len-8;j++)
   { msg[k]=comm[j];
     pc.putc(msg[k]);
     k++; }
   
   //get Sender number
   pc.printf("\n Message received from: ");
   k=0;
   for(i=33;i<=45;i++)
  { num[k]=comm[i];  
   pc.putc(num[k]);
   k++;}
   
   // Get Time
   //pc.printf("\n Message received at: ");
   //for(j=47;j<=54;j++) 
  //{log1[k]=comm[j];
   //pc.putc(log1[k]);
   //k++;}
   
  }
  
  void msg_parse()
  {
    if(num[3]==55 && num[4]==56)
    {
      if(msg[6]==79 && msg[7]==78)
        {
          time1=msg[10]-48;
          time1+=10*(msg[9]-48);
          action(1,time1);
          }
    else if(msg[6]==79 && msg[7]==70 && msg[8]==70)
        {
            action(0,0);
        }
    else
         action(2,0);
     }
    else
    action(3,0);
  }
  
  void action(int act, int dur)
  {
   if(act==1)
   { if(pwr==1)
    {
      send_sms("Your request is acknowledged, Motor is switched ON, Thank you!");
      pc.printf("\nYour request is acknowledged, Motor is switched ON, Thank you!");
      t.start();
      relay=1;
      while(t.read()<dur);
      relay=0;
      t.stop();
      t.reset(); 
      send_sms("Motor ran for requested time. Now motor is OFF, Thank you!");
      pc.printf("\nMotor ran for requested time. Now motor is OFF, Thank you!");
      }
     else
      { send_sms("Sorry, power is not available, message after sometime");
        pc.printf("Sorry, power is not available, message after sometime"); }
        
    }
    else if(act==0)
    {
    send_sms("Your request is acknowledged, Motor is switched OFF, Thank you!");
    pc.printf("Your request is acknowledged, Motor is switched OFF, Thank you!");
    relay=0;
    t.stop();
    t.reset();
    }
    else if(act==2)
    {send_sms("Sorry! Please Follow the Syntax. POWER<>ON/OFF<>time. Thank you! ");
    pc.printf("Sorry! Please Follow the Syntax. POWER<>ON/OFF<>time. Thank you! ");}
    else if(act==3)
    {send_sms("You are not authorised for this action! ");
    pc.printf("You are not authorised for this action! ");}
    
  }
  
  void manage()
  {
   time1=t.read();
   t.stop();
   send_sms("Sorry! Power supply is lost, device will switch on when power is back ");
   pc.printf("Sorry! Power supply is lost, device will switch on when power is back ");
   while(pwr==0);
   send_sms("Power is back! Motor is switched on ");
   pc.printf("Power is back! Motor is switched on");
   action(1,time1);
    }
    
  void wait_msg()
  { int common[1000];
    int i=0;
  while(1)
    {
      
      common[i]=GSM.getc();
      if(common[i]==73 && common[i-1]==84 && common[i-2]==77 && common[i-3]==67)
     { pc.printf("Msg received");
      break; }
     
     if(i>999)
     i=0;
     i++;
     
    }
  }