#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"

DigitalIn fast(p9);
DigitalIn turn(p10);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);

int main() {
    while(1) {
        if (fast) {
            time_t seconds = time(NULL);
            FILE *wave_file;
//            uLCD.cls();
            wave_file=fopen("/sd/fast.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            FILE *fp = fopen("/sd/speedlog.txt", "w");
            //if(fp == NULL) {
            //    uLCD.printf("Could not open file for write\n\r");
            //}
            fprintf(fp, "Driver drove above limit on %s\n", ctime(&seconds));
            fclose(fp);
            }
        else if (turn) {
            time_t seconds = time(NULL);
            FILE *wave_file;
            //uLCD.cls();
            wave_file=fopen("/sd/turn.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            FILE *fp = fopen("/sd/speedlog.txt", "w");
            //if(fp == NULL) {
            //    uLCD.printf("Could not open file for write\n");
            //}
            fprintf(fp, "Driver turned above g-limit on on %s\n", ctime(&seconds));
            fclose(fp);
            }
    }
}
