#ifndef _ROS_hero_msgs_hero_flipper_command_h
#define _ROS_hero_msgs_hero_flipper_command_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace hero_msgs
{

  class hero_flipper_command : public ros::Msg
  {
    public:
      typedef uint8_t _RobotMode_type;
      _RobotMode_type RobotMode;
      typedef int16_t _SweepA_type;
      _SweepA_type SweepA;
      typedef int16_t _SweepB_type;
      _SweepB_type SweepB;
      typedef int16_t _WalkDelay_type;
      _WalkDelay_type WalkDelay;
      typedef int16_t _WalkWait_type;
      _WalkWait_type WalkWait;
      typedef uint8_t _StepCount_type;
      _StepCount_type StepCount;
      typedef int16_t _WalkHeading_type;
      _WalkHeading_type WalkHeading;
      typedef uint8_t _Amplitude_type;
      _Amplitude_type Amplitude;
      typedef float _Period_type;
      _Period_type Period;
      typedef uint8_t _iteration_type;
      _iteration_type iteration;
      typedef uint8_t _OffsetAngle_type;
      _OffsetAngle_type OffsetAngle;
      typedef uint8_t _LegSwingPart_type;
      _LegSwingPart_type LegSwingPart;
      typedef uint16_t _LegSwingDelay_type;
      _LegSwingDelay_type LegSwingDelay;

    hero_flipper_command():
      RobotMode(0),
      SweepA(0),
      SweepB(0),
      WalkDelay(0),
      WalkWait(0),
      StepCount(0),
      WalkHeading(0),
      Amplitude(0),
      Period(0),
      iteration(0),
      OffsetAngle(0),
      LegSwingPart(0),
      LegSwingDelay(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      *(outbuffer + offset + 0) = (this->RobotMode >> (8 * 0)) & 0xFF;
      offset += sizeof(this->RobotMode);
      union {
        int16_t real;
        uint16_t base;
      } u_SweepA;
      u_SweepA.real = this->SweepA;
      *(outbuffer + offset + 0) = (u_SweepA.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_SweepA.base >> (8 * 1)) & 0xFF;
      offset += sizeof(this->SweepA);
      union {
        int16_t real;
        uint16_t base;
      } u_SweepB;
      u_SweepB.real = this->SweepB;
      *(outbuffer + offset + 0) = (u_SweepB.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_SweepB.base >> (8 * 1)) & 0xFF;
      offset += sizeof(this->SweepB);
      union {
        int16_t real;
        uint16_t base;
      } u_WalkDelay;
      u_WalkDelay.real = this->WalkDelay;
      *(outbuffer + offset + 0) = (u_WalkDelay.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_WalkDelay.base >> (8 * 1)) & 0xFF;
      offset += sizeof(this->WalkDelay);
      union {
        int16_t real;
        uint16_t base;
      } u_WalkWait;
      u_WalkWait.real = this->WalkWait;
      *(outbuffer + offset + 0) = (u_WalkWait.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_WalkWait.base >> (8 * 1)) & 0xFF;
      offset += sizeof(this->WalkWait);
      *(outbuffer + offset + 0) = (this->StepCount >> (8 * 0)) & 0xFF;
      offset += sizeof(this->StepCount);
      union {
        int16_t real;
        uint16_t base;
      } u_WalkHeading;
      u_WalkHeading.real = this->WalkHeading;
      *(outbuffer + offset + 0) = (u_WalkHeading.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_WalkHeading.base >> (8 * 1)) & 0xFF;
      offset += sizeof(this->WalkHeading);
      *(outbuffer + offset + 0) = (this->Amplitude >> (8 * 0)) & 0xFF;
      offset += sizeof(this->Amplitude);
      union {
        float real;
        uint32_t base;
      } u_Period;
      u_Period.real = this->Period;
      *(outbuffer + offset + 0) = (u_Period.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_Period.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_Period.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_Period.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->Period);
      *(outbuffer + offset + 0) = (this->iteration >> (8 * 0)) & 0xFF;
      offset += sizeof(this->iteration);
      *(outbuffer + offset + 0) = (this->OffsetAngle >> (8 * 0)) & 0xFF;
      offset += sizeof(this->OffsetAngle);
      *(outbuffer + offset + 0) = (this->LegSwingPart >> (8 * 0)) & 0xFF;
      offset += sizeof(this->LegSwingPart);
      *(outbuffer + offset + 0) = (this->LegSwingDelay >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (this->LegSwingDelay >> (8 * 1)) & 0xFF;
      offset += sizeof(this->LegSwingDelay);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      this->RobotMode =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->RobotMode);
      union {
        int16_t real;
        uint16_t base;
      } u_SweepA;
      u_SweepA.base = 0;
      u_SweepA.base |= ((uint16_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_SweepA.base |= ((uint16_t) (*(inbuffer + offset + 1))) << (8 * 1);
      this->SweepA = u_SweepA.real;
      offset += sizeof(this->SweepA);
      union {
        int16_t real;
        uint16_t base;
      } u_SweepB;
      u_SweepB.base = 0;
      u_SweepB.base |= ((uint16_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_SweepB.base |= ((uint16_t) (*(inbuffer + offset + 1))) << (8 * 1);
      this->SweepB = u_SweepB.real;
      offset += sizeof(this->SweepB);
      union {
        int16_t real;
        uint16_t base;
      } u_WalkDelay;
      u_WalkDelay.base = 0;
      u_WalkDelay.base |= ((uint16_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_WalkDelay.base |= ((uint16_t) (*(inbuffer + offset + 1))) << (8 * 1);
      this->WalkDelay = u_WalkDelay.real;
      offset += sizeof(this->WalkDelay);
      union {
        int16_t real;
        uint16_t base;
      } u_WalkWait;
      u_WalkWait.base = 0;
      u_WalkWait.base |= ((uint16_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_WalkWait.base |= ((uint16_t) (*(inbuffer + offset + 1))) << (8 * 1);
      this->WalkWait = u_WalkWait.real;
      offset += sizeof(this->WalkWait);
      this->StepCount =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->StepCount);
      union {
        int16_t real;
        uint16_t base;
      } u_WalkHeading;
      u_WalkHeading.base = 0;
      u_WalkHeading.base |= ((uint16_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_WalkHeading.base |= ((uint16_t) (*(inbuffer + offset + 1))) << (8 * 1);
      this->WalkHeading = u_WalkHeading.real;
      offset += sizeof(this->WalkHeading);
      this->Amplitude =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->Amplitude);
      union {
        float real;
        uint32_t base;
      } u_Period;
      u_Period.base = 0;
      u_Period.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_Period.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_Period.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_Period.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->Period = u_Period.real;
      offset += sizeof(this->Period);
      this->iteration =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->iteration);
      this->OffsetAngle =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->OffsetAngle);
      this->LegSwingPart =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->LegSwingPart);
      this->LegSwingDelay =  ((uint16_t) (*(inbuffer + offset)));
      this->LegSwingDelay |= ((uint16_t) (*(inbuffer + offset + 1))) << (8 * 1);
      offset += sizeof(this->LegSwingDelay);
     return offset;
    }

    const char * getType(){ return "hero_msgs/hero_flipper_command"; };
    const char * getMD5(){ return "5fbfca8fff5085fed6726f12aa490760"; };

  };

}
#endif
