#include "mbed.h"
typedef unsigned char BYTE;

class Command {
    
private:
    BYTE M[6];
    
public:
    Command()
    {
        M[0] = 0x03;
        M[1] = 0x00;
        M[2] = 0x00;
        M[3] = 0x00;
        M[4] = 0x00;
        M[5] = 0x00;
    }
    
    void set()
    {
        M[0] = 0x03;
        M[1] = 0x00;
        M[2] = 0x00;
        M[3] = 0x00;
        M[4] = 0x00;
        M[5] = 0x00;
    }
    
    void LIGHT(int value)
    {
        M[4] = value;        
    }
    
    void TH_L(int L)
    {
        if (L>0)
        {
            M[5] = M[5] | 4;
            M[1] = L;            
        }
        else if (L<0)
        {
            M[5] = M[5] & (~4);
            M[1] = L * -1;            
        }
        else if (L==0)
        {
            M[1] = L;            
        }        
    }
    
    void TH_R(int R)
    {
        if (R>0)
        {
            M[5] = M[5] | 8;
            M[2] = R;            
        }
        else if (R<0)
        {
            M[5] = M[5] & (~8);
            M[2] = R * -1;            
        }
        else if (R==0)
        {
            M[2] = R;            
        }        
    }
    
    void TH_H(int H)
    {
        if (H>0)
        {
            M[5] = M[5] & (~16);
            M[3] = H;            
        }
        else if (H<0)
        {
            M[5] = M[5] | 16;
            M[3] = H * -1;            
        }
        else if (H==0)
        {
            M[3] = H;            
        }        
    }
    
    BYTE* Re()
    {
        return M;        
    }
    
}; // Class Command

