#include "mbed.h"

Serial pc(USBTX,USBRX);

// I/Oピン
DigitalOut COM_on(p21); // com用のスイッチをONにするピン
DigitalOut COM_off(p22); // com用のスイッチをOFFにするピン
DigitalOut dyn(p25);

// CDH用
SPISlave to_cdh(p5,p6,p7,p8); // mosi, miso, sclk, ssel

// ADコン用
SPI mcp3208(p11,p12,p13);
DigitalOut cs_ad1(p14);

// バッテリ電圧測定用
// AnalogIn v(p16);

// グローバル変数 ***********
uint8_t EPS_cur[5];
// *************************

// ADC用関数 ******************************************
void mcp3208_Init() {
    mcp3208.format(8,0);
    mcp3208.frequency(2000000);
    uint8_t Vref = 5;
    }

uint8_t get_mcp3208() {
    cs_ad1 = 0;
    uint8_t d0 = mcp3208.write(0x06);   // ch1
    uint8_t d1 = mcp3208.write(0x40);
    uint8_t d2 = mcp3208.write(0x00);
    cs_ad1 = 1;
    uint8_t d3 = d1 << 4;
    uint8_t d = (d3 << 4) | d2;
    printf("d=%d\n\r", d);
    return(d);
    }
// ****************************************** ADC用関数終了

// ******************* main文 ***********************
int main()
{
    // ***** toCDH初期設定 *****
    to_cdh.format(8,0);
    to_cdh.frequency(1000000);
    to_cdh.reply(0x0);
    
    // ***** mcp3208初期設定 *****
    mcp3208_Init();
    
    // ローカル関数
    uint8_t ii = 0;
    // ***************************
    
    
    pc.printf("--Hi,this is eps(slave).\r\n");
    to_cdh.reply(0x01);
    
    while(1) {

        if(to_cdh.receive()) {
            int rcmd = to_cdh.read();   //receive 1st byte

            if(rcmd == 1){
                pc.printf("start spi to cdh\r\n");

                    to_cdh.reply(0x00);  // ★ 送信前データをreplyに連続で詰めたい
                    pc.printf("receive eps_cmd 1 to cdh\r\n ");
                
            }
            else if(rcmd == 2){
                pc.printf("start survivalHK sensing\r\n");
                
                    //v_bat[ii] = v.read()*3.3*8.4/3.3;
                    EPS_cur[ii] = get_mcp3208();
                    to_cdh.reply(EPS_cur[ii]);  // ★ 送信前データをreplyに連続で詰めたい
                    pc.printf("EPS_cur = %d[v]\r\n ",EPS_cur[ii]);
                    ii++;
                
                //pc.printf("finish survivalHK sensing \r\n");
                
                
            }
            else if(rcmd == 3){
                // 受信
                pc.printf("1Hz HK Interrupt\r\n");
                for(int i=0; i<4; i++){
                    EPS_cur[i] = get_mcp3208();
                }
                to_cdh.reply(EPS_cur[0]);
                pc.printf("finish HK sensing \r\n");
            }
            /*else if(rcmd == 0x07){
               to_cdh.reply(0xF0);
               pc.printf("send initial sensing data\r\n");
            }

            else if(rcmd == 0x08){
                to_cdh.reply(rcmd);
                
                pc.printf("COM ON\r\n");
                COM_on = 1;
                wait(0.5);
                COM_on = 0;
            }                   

            else if(rcmd == 0x11){
                to_cdh.reply(rcmd);
                
                pc.printf("COM OFF\r\n");
                COM_off = 1;
                wait(0.5);
                COM_off = 0;
            }                      
                     
            else if(rcmd == 0x14){
                to_cdh.reply(rcmd);
                
                pc.printf("Check battery voltage\r\n");
                for(int i=0; i<5; i++){
                    v_bat[i] = v.read()*3.3*8.4/3.3; //3.3必要？
                    pc.printf("bat_v = %f[v]\r\n ",v_bat[i]);
                    wait(1.0);
                }
                pc.printf("finish \r\n");                  
            } 
                        
            else if(rcmd == 0x15){
                to_cdh.reply(0xF1);
                pc.printf("Send battery voltage data\r\n");
            } 
                        
            else if(rcmd == 0x16){
                to_cdh.reply(rcmd);
                
                pc.printf("Heatcut ON\r\n");
                dyn = 1;
                for(int i=0; i<5; i++){
                   dyn_cur[i]= mcp3208.read_input(3)*5; //()内の数字はchナンバー
                   pc.printf("dyn_cur = %f[A]\r\n ",dyn_cur[i]);
                   wait(1.0);
                }
                dyn = 0;
                pc.printf("heat cut OFF\r\n");                
            } 
                        
            else if(rcmd == 0x17){
                to_cdh.reply(0xF2);
                pc.printf("Send cell current data\r\n");
            } 
            else{
                to_cdh.reply(0xFF);
            }
                 
            pc.printf("rcmd: %02x, dummy: %02x\r\n",rcmd, rdummy);
            */

        }
    }
}