#include "mbed.h"
SPI spi(p11,p12,p13);
DigitalOut cs(p14);
Serial pc(USBTX, USBRX);
int main(void)
{
    int bit = 8;
    spi.format(bit,0);
    spi.frequency(2000000); //VDD=5Vの場合は2MHz．
    printf("\r\n");
    printf("Starting MCP3208\r\n");
    float Vref = 5.08;
    while(1)
    {
        cs = 0;
        uint8_t d0 = spi.write(0x06);
        uint8_t d1 = spi.write(0x40);
        uint8_t d2 = spi.write(0x00);
        printf("%d,%d,%d \r\n",d0,d1,d2);
        uint8_t d3 = d1 << 4;
        uint16_t d = (d3 << 4) | d2;    // 1文にまとめると uint16_t d = (d1 << 8) | d2;
        //float volt = Vref * (float)d / 4096;
        //float amp = Vref * (float)d / 4096;
        //printf("d=%d volt=%5.2f\n\r", d, volt);
        //printf("d=%d CDH_Amp =%f [A]\n\r", d, amp);
        
        //tem

            float R3;
            float R4;
            float R5;
            float Pt;
            float R_1;
            float R_2;
        //current
            float I;
        //voltage
            float Vreft;
    
//temperature coefficient
    float ce;   
        //resistance
        R3 = 110;//[Ω]
        R4 = 1000;//[Ω]
        R5 = 68000;//[Ω]
        Pt = 100;//[Ω]
        R_1 = 3;//[kΩ]
        R_2 = 2;//[kΩ]

    //current
        I = 0.001;//[A]
    
    //voltage
        Vreft = 2.5;//[V]
    
    //Gain&Offset
        float gain = -R5*I/R4;
        float off = Vreft+I*R3;
    
    //temperature coefficient
        ce = 0.003851;
        
        float volt = Vref*(float)d / 4096*(R_1 + R_2)/R_1;
        float Rth = (volt-off)/gain+R3;
        float temp = (Rth-Pt)/(ce*Pt);
        printf("d=%d EPS_Temp =%f [℃]\n\r", d, temp);
        
        cs = 1;
        wait(1.0);
    }
}