//reference
//https://docs.google.com/document/d/197dgqlNFhn72JrBeSYGtR4Y7DJQRUKC61oHVD9dvLNY/edit
#include "mbed.h"
SPI ADC(p11,p12,p13);
DigitalOut cs[2] = {p14, p26};
Serial pc(USBTX, USBRX, 9600);
#define START_BIT   0x04
#define MODE_SINGLE 0x02    // Single-ended mode
#define MODE_DIFF   0x00    // Differential mode
uint16_t MCP3208_get(int channel, int adc_num);
uint16_t HK_data[40];
int rcmd = 0,cmdflag = 0, hk_num = 0; 
uint16_t d;
void commandget();
void initialize();
// for temp
float R3 = 110;
float R4 = 1000;
float R5 = 68000;
float Pt = 100;
float R_1 = 3;
float R_2 = 2;
float I = 0.001;
float Vreft = 2.5;
float ce = 0.003851;
float Rth, temp, volt;
float Rse=0.02;
float Gain=50;

float gal;

int main(void)
{
    int bit = 8;
    float Vref = 5;
    ADC.format(bit,0);
    ADC.frequency(2000000); //VDD=5Vの場合は2MHz．
    pc.printf("\r\n");
    pc.printf("Hello, eps. This is MCP3208 test code.\r\n");
    pc.printf("if you wanna start, press *a*. \r\n");
    // for temp calucuration
    float gain = -R5*I/R4;
    float off = Vreft+I*R3;
    
    
    while(1){
        commandget();
        if(cmdflag == 1){
            if(rcmd == 'a'){
                for(int adc_num = 0; adc_num < 2; adc_num++){
                    for(int i = 0; i < 3; i++){
                        HK_data[hk_num] = MCP3208_get(i, adc_num);
                        pc.printf("ADC_num: %d, return = %d\n\r",adc_num, HK_data[hk_num]);
                        hk_num++;
                    }
                }
                //3.3V
                pc.printf("CH[0]: Volt = %.5f[V]\n\r", Vref * (float)HK_data[0] / 4096);
                //Temperature
                volt = Vref*(float)HK_data[1] / 4096*(R_1 + R_2)/R_1;
                Rth = (volt-off)/gain+R3;
                temp = (Rth-Pt)/(ce*Pt);
                pc.printf("CH[1]: Temp = %.5f[degree]\n\r", temp);
                //Galvanometer
                gal = Vref * (float)HK_data[2] / 4096/Gain/Rse;
                pc.printf("CH[2]: Galvanometer = %.5f[A]\n\r", gal);
            }
        }
        for(int j=0; j<hk_num; j++){
            pc.printf("HK[%d]: %d\n\r", j, HK_data[j]);
        } 
        initialize();
    }
    
    /*
    
    for(int i = 0; i < 10; i++){
        uint16_t d = MCP3208_get(1);
        HK_data[i] = d;
        pc.printf("return=%d volt=%.5f\n\r", d, Vref * (float)d / 4096);
        wait(1.0);
    }
    pc.printf("Sencing Finish\n\r");
    pc.printf("Print HK_data\n\r");
    
    for(int i = 0; i < 10; i++){
        pc.printf("HK_data[%d] = %d\n\r", i, HK_data[i]);
    }
    */
}


uint16_t MCP3208_get(int channel, int adc_num){
    cs[adc_num] = 0;
    pc.printf("Channel: %d, ", channel);
    int command_high = START_BIT | MODE_SINGLE | ((channel & 0x04) >> 2);
    int command_low = (channel & 0x03) << 6;
    ADC.write(command_high);
    int high_byte = ADC.write(command_low) & 0x0F;
    int low_byte = ADC.write(0x00);
    int conv_result = (high_byte << 8) | low_byte;
    cs[adc_num] = 1;
    return conv_result;
}


void commandget()
{
    rcmd = pc.getc();
    cmdflag = 1;
    pc.printf("get command: %d,%d\r\n",rcmd,cmdflag);
}
void initialize()
{
    rcmd = 0;
    cmdflag = 0;
    hk_num = 0;
}
