/* File: TB6612FNG.h
 * Author: Robert Abad      Copyright (c) 2013
 *
 * Desc: driver for TB6612FNG Motor Driver.  For further details see
 *       header file, TB6612FNG.h
 */

#include "mbed.h"
#include "TB6612FNG.h"

#define SIGNAL_HIGH     (1)
#define SIGNAL_LOW      (0)

TB6612FNG::TB6612FNG( PinName pinPwmA, PinName pinAin1, PinName pinAin2, PinName pinPwmB, PinName pinBin1, PinName pinBin2, PinName pinNStby ) :
pwmA(pinPwmA),
Ain1(pinAin1),
Ain2(pinAin2),
pwmB(pinPwmB),
Bin1(pinBin1),
Bin2(pinBin2),
nStby(pinNStby)
{
    Ain1 = SIGNAL_LOW;
    Ain2 = SIGNAL_LOW;
    Bin1 = SIGNAL_LOW;
    Bin2 = SIGNAL_LOW;
    pwmA = SIGNAL_LOW;
    pwmB = SIGNAL_LOW;
    //pwmA.period(TB6612FNG_PWM_PERIOD_DEFAULT);
    //pwmA = TB6612FNG_PWM_PULSEWIDTH_DEFAULT;
    //pwmB.period(TB6612FNG_PWM_PERIOD_DEFAULT);
    //pwmB = TB6612FNG_PWM_PULSEWIDTH_DEFAULT;
    nStby = SIGNAL_LOW;
    
    on_delayA = 0;
    off_delayA = 0;
    on_delayB = 0;
    off_delayB = 0;
}

void TB6612FNG::setPwmA(int p_us, float dc)
{    
    timerA.detach();
    if ((p_us == 0) || (dc == 0)) {
        pwmA = 0;
        return;
    }
    if (dc >= 1) {
        pwmA = 1;
        return;
    }
    on_delayA = (int)(p_us * dc);
    off_delayA = p_us - on_delayA;
    toggleA_On();
}

void TB6612FNG::setPwmB(int p_us, float dc)
{
    timerB.detach();
    if ((p_us == 0) || (dc == 0)) {
        pwmB = 0;
        return;
    }
    if (dc >= 1) {
        pwmB = 1;
        return;
    }
    on_delayB = (int)(p_us * dc);
    off_delayB = p_us - on_delayB;
    toggleB_On();
}

void TB6612FNG::standby(void)
{
    nStby = SIGNAL_LOW;
}

void TB6612FNG::motorA_stop(void)
{
    Ain1 = SIGNAL_LOW;
    Ain2 = SIGNAL_LOW;
}

void TB6612FNG::motorA_ccw(void)
{
    Ain1 = SIGNAL_LOW;
    Ain2 = SIGNAL_HIGH;
    nStby = SIGNAL_HIGH;
}

void TB6612FNG::motorA_cw(void)
{
    Ain1 = SIGNAL_HIGH;
    Ain2 = SIGNAL_LOW;
    nStby = SIGNAL_HIGH;
}

void TB6612FNG::motorB_stop(void)
{
    Bin1 = SIGNAL_LOW;
    Bin2 = SIGNAL_LOW;
}

void TB6612FNG::motorB_ccw(void)
{
    Bin1 = SIGNAL_LOW;
    Bin2 = SIGNAL_HIGH;
    nStby = SIGNAL_HIGH;
}

void TB6612FNG::motorB_cw(void)
{
    Bin1 = SIGNAL_HIGH;
    Bin2 = SIGNAL_LOW;
    nStby = SIGNAL_HIGH;
}

void TB6612FNG::toggleA_On(void) {
    pwmA = 1;
    timerA.attach_us(this, &TB6612FNG::toggleA_Off, on_delayA);
}

void TB6612FNG::toggleA_Off(void) {
    pwmA = 0;
    timerA.attach_us(this, &TB6612FNG::toggleA_On, off_delayA);
}

void TB6612FNG::toggleB_On(void) {
    pwmB = 1;
    timerB.attach_us(this, &TB6612FNG::toggleB_Off, on_delayB);
}

void TB6612FNG::toggleB_Off(void) {
    pwmB = 0;
    timerB.attach_us(this, &TB6612FNG::toggleB_On, off_delayB);
}

