#include "mbed.h"
#include "rtos.h"
#include "C12832.h"
#include "EthernetInterface.h"
#include "math.h"
#include "Websocket.h"

#define POT_SENSITIVITY (0.01f)    
#define WS_CONNECT_RETRY (20)
#define WS_SEND_RETRY (5)
  
C12832 lcd(p5, p7, p6, p8, p11);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
BusIn joystick(p12, p13, p14, p15, p16);

Mutex lcd_mutex;
Mutex second_mutex;
 
static unsigned int second = 0;
static float pt1 = 0;
static float pt2 = 0;
static int js = 0xFF;

void potJoystickThread(void const *args)
{
   
    
    printf("PotJoysticThread Start\r\n");
    
    while(1)
    {
    
        float p1 = pot1.read();
        float p2 = pot2.read();
        int j = joystick.read();
            
        if(fabs(p1 - pt1) > POT_SENSITIVITY || fabs(p2 - pt2) > POT_SENSITIVITY || j != js)
        {      
            pt1 = p1;
            pt2 = p2;
            js = j;   
            
            r = 1 - pt1;
            g = 1 - pt2;
            
            if(0x10 == js)b = 0; //right, turn on blue led 
            else if (0x02 == js)  b = 1;   //left, turn of blue led
            else if(0x01 == js)   b.write( b + 0.05); //down
            else if(0x08 == js)   b.write( b - 0.05); //up
            
            //printf("Pot1 : %.2f  Pot2 : %.2f  Joystick:%02X\r\n", pt1, pt2, js);
                
            //lcd display
            lcd_mutex.lock();
            lcd.locate(0,11);
            lcd.printf("Pot1 : %.2f Pot2 : %.2f JS:%02X", pt1, pt2, js);
            lcd_mutex.unlock();
        }
       
        Thread::wait(100);
    }
    
}

void netThread(void const *args)
{
   bool  is_eth_connected = false;
   printf("EthernetInterface Thread Start\r\n");
   EthernetInterface eth;
   eth.init(); //Use DHCP
   printf("MAC:%s\r\n",eth.getMACAddress()); 
   lcd_mutex.lock();
   lcd.locate(0,21);
   lcd.printf("MAC:%s\r\n",eth.getMACAddress());
   lcd_mutex.unlock();
   printf("Connecting...\r\n");
   
   while(1)
   {
        if(0 != eth.connect())
        {
            printf("Connecting fail! Try again. \r\nConnecting....\r\n");   
            if(is_eth_connected)
            {               
                if(0 == eth.disconnect())
                {
                      printf("Disconnect OK\r\n");
                }
                else 
                {
                      printf("Disconnect error\r\n");
                }
            }
            is_eth_connected = false;
            Thread::wait(100);   
        }
        else
        {
            printf("Connect OK! IP Address is %s\r\n", eth.getIPAddress());
            lcd_mutex.lock();
            lcd.locate(0,21);
            lcd.printf("IP ADDRESS : %s\r\n",eth.getIPAddress());
            lcd_mutex.unlock();
            is_eth_connected = true;
     
        }       
        
        if(is_eth_connected)
        {
            Websocket ws("ws://sockets.mbed.org:443/ws/gordonlu/wo");            
            int i = 0;
            while(++i < WS_CONNECT_RETRY)
            {
                printf("[%d] WebSwerivce connect to ws://sockets.mbed.org:443/ws/gordonlu/wo \r\n",i);
                if(ws.connect())break;
                Thread::wait(1000);  
            }
           
            int errCnt = 0;
            while (ws.is_connected())
            {     
                 
                char buf[100];
                int scnt = sprintf(buf, "[%u] Hello! Pot1 : %.2f, Pot2 : %.2f, Joystick:%02X\r\n", second, pt1, pt2, js);              
                if((ws.send(buf)) >= scnt)
                {
                      printf(buf);
                      errCnt = 0;
                }       
                else
                {
                    printf("[%d] ws.send failed!!\r\n",++errCnt);
                }      
                     
                if(errCnt > WS_SEND_RETRY)
                {
                    printf("close ws and disconnect eth, retry to connect again!\r\n");
                    ws.close();
                    break;
                } 
                
                Thread::wait(1000);            
            }           
        }
    }   
}

void secondCounterThread(void const *args)
{
    while(1)
    {
        second_mutex.lock();
        ++second;
        second_mutex.unlock();
        myled1 != myled1;
        Thread::wait(1000);
    }
}

int main()
{
   
    lcd.cls();

    r.period(0.001);
    g.period(0.001);
    b.period(0.001);
      
    r = 1;
    g = 1;
    b = 1;
    
    Thread t1(netThread);   
    Thread t2(potJoystickThread);  
    Thread t3(secondCounterThread);  
          
    while(true)
    {  
        lcd_mutex.lock();
        lcd.locate(0,1);
        lcd.printf("Second : %06d ",second);
        lcd_mutex.unlock();
        Thread::wait(1000); 
    }
}