#include "mbed.h"
#include "WIFIDevice.h"
#include "EthernetInterface.h"

WIFIDevice wifi;

const char* PC_SERVER_ADDRESS_1 = "10.0.1.2";
const char* PC_SERVER_ADDRESS_2 = "10.0.1.3";
uint16_t PC_PORT = 5222;

DigitalOut LED01(p13);
DigitalOut LED02(p7);
Serial pc(USBTX, USBRX);//debug port , 9600


int main(void)
{   
      
    EthernetInterface eth;
    eth.init(); //Use DHCP
    wait(1);
    printf( "Hello World, NNN40_WiFi\n");
    // set given SSID and PW as the highest priority  
    //wifi.setNetwork("KORYO-Guest", "koryo123", 0);
    wifi.setNetwork("Airport123", "12345678", 0);
    wait(1);
   
    eth.connect(40000);
    printf("****IP Address:%s\n",eth.getIPAddress());
    printf("****MAC Address:%s\n",eth.getMACAddress());

  
    
    TCPSocketConnection socket1; 
    printf("Connect to %s:%d\n",PC_SERVER_ADDRESS_1,PC_PORT);    
    if(0 == socket1.connect(PC_SERVER_ADDRESS_1,PC_PORT))
    {
         LED01 = 1;
         printf("****socket1 connect ok!!!\n");
    }
    else
    {
        printf("****socket connect1 failed !!\n");
    }
   
    TCPSocketConnection socket2;   
    printf("Connect to %s:%d\n",PC_SERVER_ADDRESS_2,PC_PORT);     
    if(0 == socket2.connect(PC_SERVER_ADDRESS_2,PC_PORT))
    {
         
         LED02 = 1;
         printf("****socket2 connect ok!!!\n");
    }
    else
    {
        printf("****socke2 connect failed !!\n");
    }
   
    char msg[] = "Hello World";
    char buf[1024];
    
    int i = 1;
    while(1)
    {
        wait(1);
        int j = sprintf(buf, "Hello World : %d\n",i);
        printf("******************Send Message : %d \n", i++);
        socket1.send(buf, j);    
        socket2.send(buf, j);   
        
        if(i%2 == 0 )  LED02 = 1;
        else LED02 = 0; 
    }
    printf("****socket close \n");
    //socket1.close();
    //socket2.close();
    eth.disconnect();
    wifi.sleep();

}
