#include "mbed.h"



#define TYPE_MEASEUREMENT 0xA


#define ST_TX D1
#define ST_RX D0
#define RTS D15



DigitalOut led1(LED1);
Serial pc(USBTX, USBRX, NULL, 115200); // tx, rx
DigitalIn pin_rts(RTS);
DigitalIn button(USER_BUTTON);
Serial st_uart(ST_TX, ST_RX, NULL, 115200); // tx, rx

 

uint8_t test_vector[10000];


void uart_busy_check(void)
{
    while (pin_rts == 0)
    {
        // do nothing
        led1=0;
    } 
}
 
 
void write_sample(uint16_t sample) 
{
   led1=1;
   
   uint8_t byte_little = ((uint8_t *)&sample)[0];
   uint8_t byte_big = ((uint8_t *)&sample)[1];
 
   st_uart.putc(byte_little);
   st_uart.putc(byte_big);
     
   uart_busy_check();
}
 
int main() {
 
    led1=1;
    pc.printf("About to simulate data over the second uart D1 (Tx), D0 (Rx) - **Press button**... \n\r");
    
    while (!button)
    {
        
    }
    
    pc.printf("Button pressed! Starting...");
    
    while(1)
    {
    
      /* simulate data */
      for (uint16_t i=0; i<10; i++)
      {
        st_uart.putc(TYPE_MEASEUREMENT);
        st_uart.putc(0x00); /* CRC */
        
        if (i<9)
          st_uart.putc(i);  /* INDEX  (incrementing) */
        else
          st_uart.putc(255);  /* end of measurement 255 (0xff) */
          
        /* SIZE OF SAMPLES 5000 == 10000 bytes */
        uint16_t size_of_samples = 5000;
        uint8_t byte_little = ((uint8_t *)&size_of_samples)[0];
        uint8_t byte_big = ((uint8_t *)&size_of_samples)[1];
        st_uart.putc(byte_little);
        st_uart.putc(byte_big);
        
        for (int i=0; i<5000; i++)
        {     
           write_sample(i);
        }
        
      }
      
    }
}
