#include "mbed.h"
//Program to 'sweep' test a 'standard RC type servo
//Define some parameters using compiler directive '#define'
//Check Servo DATA if 0.75ms to 2.25ms then use min=750 and max=2250
//NB be values in microseconds (Following are generic values)
#define MID         1500
#define MIN         544
#define MAX         2400
#define STEP          50
//Time delay between steps in milliseconds
#define TIME         20 //100


#define DELTA 50
 
DigitalOut myLed(LED1);
DigitalIn  myButton(USER_BUTTON);

DigitalIn  myButton_2(D0);
 
PwmOut myServo(D3);
 
 
 

 void motor_on(void)
 {
  
      //myServo.period_ms(20);
    myServo.pulsewidth_us(MID); //NB in microseconds
     
 }
 
 void motor_off(void)
 {
     myServo.pulsewidth_us(MIN+2*DELTA); //NB in microseconds
 }
 
 
bool button_change = false;
 
int main() {
  
  wait(1); 
  
  myServo.pulsewidth_us(MAX); //NB in microseconds
  wait(3);

  
  while (1)
  {


    
    if (myButton)
    {
        
        
      for (int i=MAX; i>MIN; i=i-10)  
      {
        myServo.pulsewidth_us(i); //NB in microseconds
        wait_ms(25);
      }  
        
      for (int i=MIN; i<MAX; i=i+10)  
      {
        myServo.pulsewidth_us(i); //NB in microseconds
        wait_ms(25);
      }
      
      wait(1);
      

      
     
    }

    

    
    
  }

    
}