#include "mbed.h"

#include "AT45.h"

/* Tested on L-Tek FF_LPC546xx */

#define PIN_MOSI P0_8
#define PIN_MISO P0_9
#define PIN_SCK  P0_6
#define PIN_CS   P0_7


DigitalOut led1(LED1);

SPI spi(PIN_MOSI, PIN_MISO, PIN_SCK);  // mosi, miso, sclk
AT45 spif(&spi, PIN_CS);

DigitalOut myled(LED1);

int main() {

    printf("spif test\n\r");
    
    
    printf("id: %d\n\r",   spif.id());
  
    printf("spif size: %d bytes\n\r",         spif.device_size());
    printf("spif page erase size: %d bytes\n\r",    spif.pagesize());
    printf("spif pages: %d\n\r",    spif.pages());
    printf("spif block erase size: 4096 bytes\n\r");
    printf("spif blocks: %d\n\r", spif.blocks());
    printf("id: %d\n\r",   spif.id());

    int pagesize = spif.pagesize();
    
    // Write "Hello World!" to a block
    char *buffer = (char*) malloc(pagesize);
    sprintf(buffer, "Hello World!\n");
    spif.page_erase(3);
    spif.write_page(buffer, 3);

    char *buffer2 = (char*) malloc(pagesize);
    // Read back what was stored
    spif.read_page(buffer2, 3);

    printf("%s", buffer2);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
                
    }
}
