#include "mbed.h"

#include "AT45.h"

/* Tested on FRDM-KW24D512 */

SPI spi(D11, D12, D13); 
AT45 spif(&spi, D10);

DigitalOut myled(LED1);

int main() {

    printf("spif test\n\r");
  
    printf("spif size: %d bytes\n\r",         spif.device_size());
    printf("spif page erase size: %d bytes\n\r",    spif.pagesize());
    printf("spif pages: %d\n\r",    spif.pages());
    printf("spif block erase size: 4096 bytes\n\r");
    printf("spif blocks: %d\n\r", spif.blocks());
    printf("id: %d\n\r",   spif.id());

    int pagesize = spif.pagesize();
    
    // Write "Hello World!" to a block
    char *buffer = (char*) malloc(pagesize);
    sprintf(buffer, "Hello World!\n");
    spif.page_erase(3);
    spif.write_page(buffer, 3);

    char *buffer2 = (char*) malloc(pagesize);
    // Read back what was stored
    spif.read_page(buffer2, 3);

    printf("%s", buffer2);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
                
    }
}
