#include "mbed.h"
DigitalOut led1(LED1);
DigitalOut ROW1(PA_6);
DigitalOut ROW2(PA_7);
DigitalOut ROW3(PB_6);
DigitalOut ROW4(PC_7);
DigitalIn COL1(PA_9, PullUp);
DigitalIn COL2(PA_8, PullUp);
DigitalIn COL3(PB_10, PullUp);
DigitalIn COL4(PB_4, PullUp); //Connecting the inputs and outputs of the keypad to board
int const numRows = 4;
int const numCols = 4;
bool cols[4];
char keys[numRows][numCols] = {
{'1','2','3','A'},
{'4','5','6','B'},
{'7','8','9','C'},
{'*','0','#','D'},
}; //Grid of characters for output when system is running the code following keypad
int colPress = 0;
void readCols()
{
cols[0] = COL1.read();
cols[1] = COL2.read();
cols[2] = COL3.read();
cols[3] = COL4.read();
}
bool checkPress()
{
for(int i=0; i<numCols; i++){
if(!cols[i]){
colPress = i;
return true;
}
}
return false;
}
char scan()
{
int currentRow = 0;
while(1){
ROW1 = 1;
ROW2 = 1;
ROW3 = 1;
ROW4 = 1;
wait_ms(10);
currentRow = 1;
ROW1 = 0;
wait_ms(5);
readCols();
if(checkPress()){
return keys[currentRow-1][colPress];
}
wait_ms(5);
ROW1 = 1;
currentRow = 2;
ROW2 = 0;
wait_ms(5);
readCols();
if(checkPress()){
return keys[currentRow-1][colPress];
}
wait_ms(5);
ROW2 = 1;
currentRow = 3;
ROW3 = 0;
wait_ms(5);
readCols();
if(checkPress()){
return keys[currentRow-1][colPress];
}
wait_ms(5);
ROW3 = 1;
currentRow = 4;
ROW4 = 0;
wait_ms(5);
readCols();
if(checkPress()){
return keys[currentRow-1][colPress];
}
wait_ms(5);
ROW4 = 1;
}
} //All above is the system of how the inputs of button pressing are read
int main()
{
char input, previousInput;
char match[5] = {'#','1','2','0','2'}; //Backwards because that’s how the input will be read
char priorCpy[5]; //Works as a password as only looking at last 5 inputs.
char priorInput[5]; //Char functions here are the five input password needed
int yesCount = 0;
printf("Enter code.\n\r");
while(1){
input = scan();
if(input != previousInput){
for(int i=0; i<5; i++){
priorCpy[i] = priorInput[i];
printf("%c", priorCpy[i]);
}
printf("\r\n");
priorInput[0] = input;
for(int i=1; i<5; i++){
priorInput[i] = priorCpy[i-1];
}
}
yesCount = 0;
for(int i=0; i<5; i++){
if(priorInput[i] == match[i]){
yesCount++; //Essentially ‘going’ through each character checking if its part of combo
}
}
if(yesCount == 5){
led1 = 1;
}
if(input == '*'){
led1 = 0;
}
previousInput = input;
printf("input = %c\r\n", input); //Buggy with the button constantly pressed multiple outputs
}
}