#include "mbed.h"

// Set Board Pins
DigitalIn columns[4] = { PA_9, PA_8, PB_10, PB_4 };                            
DigitalOut rows[4] = { PA_6, PA_7, PB_6, PC_7  };                       
char numpad[] = "123A456B789C*0#D";                                         

// Includes the Assembly code 
extern "C" int 
    add_asm(int a, int b),
    sub_asm(int a, int b),
    mul_asm(int a, int b),
    div_asm(int a, int b),
    vdiv_asm(int a, int b);


// External function to call arithmetic
int mathFunc(int n0, int n1, int mathfunc){
    int answer;                                                         //  For switch functions to cast
    
    switch(mathfunc) {                                                  //  Choose arithmetic operator
        case 0: {                                                       //  Addition
            answer = add_asm(n0, n1);
            break;            
            }
        case 1: {                                                       // Subtraction
            answer = sub_asm(n0, n1);
            break;
            }
        case 2: {                                                       // Multiplication
            answer = mul_asm(n0, n1);
            break;
            }
        case 3: {                                                       // Division
            answer = div_asm(n0, n1);
            break;
            }
            default: 
            answer = 555;
            break;
    }
    //printf ("%d",mathfunc);  
    return answer; 
                                                       // Output answer from chosen operator
}

int inputToInt(char a[5],int index, int& step) {
    if(a[index - 1] == 'A' || a[index - 1] == 'B' || a[index - 1] == 'C' || a[index - 1] == 'D') {
        printf("\nERROR: None Number Input!\n");
        step--;
        return 0;     
    }
    else {
        return atoi(a);
    }
}

int main() {


    // Set Columns
    columns[0].mode(PullUp);                                            // Set column 0 to pullup mode
    columns[1].mode(PullUp);                                            // Set column 1 to pullup mode
    columns[2].mode(PullUp);  
    columns[3].mode(PullUp);                                          // Set column 2 to pullup mode

    // Required Variables
    char input[5] = "";                                                 // Array to hold stored values
    int inputIndex = 0;                                                 // Index for current input array position
    int n0 = 0;                                                         // First integer store
    int n1 = 0;                                                         // Second integer store
    int mathfunc = 0;                                                   // Int variables to hold stored integer
    int step = 0;                                                       // Int variable for determining switch case
    
    //Initial Prompt
    printf("\n\rUsing the keypad, enter your numbers, then press '#' to move to next step.\n\r");
    printf("Input first number:   ");
    fflush(stdout);
    
    while(1) {
        for (int i = 0; i < 5; i++) {                                   //  Perform functions for every keypad row i
            
            // Set Rows
            rows[0] = 1;                                                //   Set row 0 to value of 1
            rows[1] = 1;                                                //   Set row 1 to value of 1
            rows[2] = 1;                                                //   Set row 2 to value of 1
            rows[3] = 1;                                                //  Set row 3 to value of 1
            rows[4] = 1;
            rows[i] = 0;                                                //  Set row i to value of 0
            wait(0.01);                                                 //  Force hold row i at value 0 for 10 ms
            
            // Read Columns
            for (int j = 0; j < 4; j++) {                               //   Perform for each column 
                if (columns[j] == 0) {                                  // If this column has been pulled down to 0
                    // Read button
                    int pos = 4 * i + j;                                // Find position in numpad[]

                    if (pos == 12) {}                                    //  '*', do nothing
                    else if (pos == 14) {                               //  '#', ...
                        if (inputIndex == 0) {                          //  current input is empty
                            input[inputIndex] = '0';                    //  '0' to input
                            input[inputIndex+1] = '\0';                 //  Close array
                        }
                        switch(step) {                                  //  Check for current step in program
                            case 0: {   step = 1;
                                        n0 = inputToInt(input, inputIndex, step);               //  For step = 0, convert and store input to n0
                                        if(step == 1) {
                                            printf("\n\rInput second number:  ");
                                        }
                                        else {
                                            printf("\n\rInput first number:  ");
                                        }
                                        fflush(stdout);
                                        break;                          //  End case 0
                                    }
                            case 1: {   
                                        step = 2;
                                        n1 = inputToInt(input, inputIndex, step);               //  For step = 1, convert and store input to n1
                                        if (step == 2) {
                                            printf("\n\rSelect an operand:\n\r"); //  Operator Menu
                                            printf("  (A) +\n\r");        
                                            printf("  (B) -\n\r");   
                                            printf("  (C) *\n\r");   
                                            printf("  (D) /\n\r");    
                                            printf("Input option number:  ");
                                        }
                                        else {
                                            printf("\n\rInput second number:  ");
                                        }
                                        
                                        fflush(stdout);
                                        
                                        break;                          //  End case 1
                                    }
                            case 2: {   
                                        if(input[inputIndex - 1] == 'A' || input[inputIndex - 1] == 'B' || input[inputIndex - 1] == 'C' || input[inputIndex - 1] == 'D') {
                                            
                                            mathfunc = ((int)input[inputIndex - 1]) - 65;
                                            int x = mathFunc(n0, n1, mathfunc);  // Send two numbers and operator for parsing
                                            printf("\n\rAnswer = %d\n\r", x);  // Output answer
                                            printf("\n\rInput first number:  ");
                                            
                                            step = 0;                       //  Set step to 0
                                            n0 = 0;                         //  Set first number to 0
                                            n1 = 0;                         //  Set second number to 0
                                        }
                                        else {
                                            printf("\nERROR: Invalid Operator!\n");
                                            printf("\n\rSelect an operand:\n\r"); //  Operator Menu
                                            printf("  (A) +\n\r");        
                                            printf("  (B) -\n\r");   
                                            printf("  (C) *\n\r");   
                                            printf("  (D) /\n\r");    
                                            printf("Input option number:  ");
                                            step = 2;
                                        }
                                        fflush(stdout);
                                        break;                          //  End case 2
                                    }                                        
                        }
                        input[0] = '\0';                                //  Clear input
                        inputIndex = 0;                                 //  Revert input index to 0
                    } else {                                            //  Any number value pressed on keypad
                        input[inputIndex] = numpad[pos];                //  Append current digit to input
                        input[inputIndex + 1] = '\0';                   //  Close array
                        inputIndex++;                                   //  Advance input index to next position
                        printf("%c", numpad[pos]);
                        fflush(stdout);
                    }

                    wait(0.005);                                        //  Force read column j for 5 ms
                    while (columns[j] == 0);                            //  Wait for current button to be released
                }
            }
        }
    }
}