#include "mbed.h"
#include "pt.h"

#define NBUFF 10

typedef enum {
    e_ValidInput,
    e_Init,
} Event_t;

DigitalOut myled_1(LED1);
DigitalOut myled_2(LED2);
AnalogIn input_1(p17);
AnalogIn input_2(p20);
DigitalIn charger_1(p16);
DigitalIn charger_2(p19);
DigitalOut ground_1(p15);
DigitalOut ground_2(p18);
Serial pc(USBTX, USBRX); // tx, rx

int buff_1, buff_2;
int last_1, last_2;
char trigger[128];
int tr_len, tr_pos;
char key;

int touchSense_1(void);
int touchSense_2(void);
int keyPressed();
int buttonTouched();
char readTouchInput();


// int flag;
Event_t ev;

static
PT_THREAD(pt_serial(struct pt *pt)) {
    PT_BEGIN(pt);
    while (1) {
        PT_YIELD_UNTIL(pt, ev == e_Init);
        trigger[0] = '\0';
        tr_len = 0;
        pc.printf("Please input the trigger string in the format of Sbbb...bbbE\n\r");
        PT_YIELD_UNTIL(pt, keyPressed());
        if (key != 'S') {
            pc.printf("HOST ERROR\n\r");
            PT_EXIT(pt);
        }
        while (1) {
            PT_YIELD_UNTIL(pt, keyPressed());
            if (key == 'E') {
                pc.printf("\n\r");
                if (tr_len == 0) {
                    pc.printf("HOST ERROR\n\r");
                    PT_EXIT(pt);
                } else {
                    trigger[tr_len] = '\0';
                    break;
                }
            } else if (key == '0' || key == '1') {
                trigger[tr_len++] = key;
                pc.putc(key);
            } else if (key == ' ') {
                pc.putc(key);
            } else {
                pc.printf("\n\rHOST ERROR\n\r");
                PT_EXIT(pt);
            }
        }
        // Now we can process to Touch Input
        ev = e_ValidInput;
    }
    PT_END(pt);
}

static
PT_THREAD(pt_touch(struct pt *pt)) {
    PT_BEGIN(pt);
    while (1) {
        PT_YIELD_UNTIL(pt, ev == e_ValidInput);
        pc.printf("The trigger string is %s\n\r", trigger);
        pc.printf("Please start to touch the button\n\r");
        tr_pos = 0;
        while(tr_pos < tr_len) {
            PT_YIELD_UNTIL(pt, buttonTouched());
            pc.putc(key);
            if (key != trigger[tr_pos++]) {
                pc.printf("\n\rTOUCH ERROR\n\r");
                ev = e_Init;
                PT_EXIT(pt);
            }
        }
        pc.printf("\n\r");
        pc.printf("MATCH\n\r");
        ev = e_Init;
        PT_EXIT(pt);
    }
    PT_END(pt);
}

static struct pt pt1, pt2;
int main() {
    PT_INIT(&pt1);
    PT_INIT(&pt2);
    // flag = S_SERIAL;
    ev = e_Init;
    while (1) {
        pt_serial(&pt1);
        pt_touch(&pt2);
    }
}

int keyPressed() {
    key = pc.getc();
    return 1;
}

int buttonTouched() {
    key = readTouchInput();
    return 1;
}

int touchSense_1(void) {
    float sample;
    ground_1 = 0;
    charger_1.mode(PullUp);
    charger_1.mode(PullNone);
    sample=input_1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int touchSense_2(void) {
    float sample;
    ground_2 = 0;
    charger_2.mode(PullUp);
    charger_2.mode(PullNone);
    sample=input_2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

char readTouchInput() {
    while (1) {
        if (touchSense_1()) {
            myled_1 = 1;
            if (!last_1) {
                last_1 = 1;
                buff_1 = NBUFF;
            }
        } else {
            if (last_1) {
                last_1 = 0;
            } else {
                if (buff_1 == 0) {
                    if (myled_1) {
                        myled_1 = 0;
                        return '0';
                    }
                } else {
                    buff_1--;
                }
            }
        }
        if (touchSense_2()) {
            myled_2 = 1;
            if (!last_2) {
                last_2 = 1;
                buff_2 = NBUFF;
            }
        } else {
            if (last_2) {
                last_2 = 0;
            } else {
                if (buff_2 == 0) {
                    if (myled_2) {
                        myled_2 = 0;
                        return '1';
                    }
                } else {
                    buff_2--;
                }
            }
        }
        wait(0.005);
    }
}
