#include "mbed.h"

const int TRIGGER_LEN = 128;
const int NBUFF = 10;

typedef enum {s_Init, s_Input} PC_State;

DigitalOut myled_1(LED1);
DigitalOut myled_2(LED2);
AnalogIn input_1(p17);
AnalogIn input_2(p20);
DigitalIn charger_1(p16);
DigitalIn charger_2(p19);
DigitalOut ground_1(p15);
DigitalOut ground_2(p18);
Serial pc(USBTX, USBRX); // tx, rx

int buff_1, buff_2;
int last_1, last_2;
char key;

// PC_State pc_State = s_Init;
char tmptr[TRIGGER_LEN];
char trigger[TRIGGER_LEN];
char detectW[TRIGGER_LEN];
size_t tmp_len, tr_len;
size_t window_sz, match_len;

bool pcinput;           // then true, PC is reading input from the host. Otherwise, wait user press the 'S' button.
void getSerialInput();
int touchSense_1(void);
int touchSense_2(void);
int buttonTouched();
char readTouchInput();
int isIdentity(char* cp1, char* cp2, size_t len);
void windowShift(char* wpt, size_t len);
void printDetectWindow(char* wpt, size_t len);

int main() {
    tmp_len = 0;
    tr_len = 0;
    pcinput = 0;
    match_len = 0;
    window_sz = 0;
    memset(tmptr, 0, TRIGGER_LEN);
    memset(trigger, 0, TRIGGER_LEN);
    memset(detectW, 0, TRIGGER_LEN);
    pc.attach(&getSerialInput);
    pc.printf("Please input the trigger string in the format of Sbbb...bbbE\n\r");
    while(buttonTouched()) {
        if (tr_len) {
            if (window_sz == tr_len) {
                windowShift(detectW, tr_len);
                detectW[tr_len - 1] = key;
                printDetectWindow(detectW, window_sz);
                if (isIdentity(detectW, trigger, tr_len)) {
                    pc.printf("MATCH\n\r");
                }
            } else {
                detectW[window_sz++] = key;
                printDetectWindow(detectW, window_sz);
                if (window_sz == tr_len) {
                        if (isIdentity(detectW, trigger, tr_len)) {
                        pc.printf("MATCH\n\r");
                    }
                }
            }
        }
    }
}

void getSerialInput() {
    char tmp_char = pc.getc();
    if (tmp_char == 'S') {
        tmp_len = 0;
        tr_len = 0;         // If user starts to input a new trigger string
                            // automatically disable the old one. At this period,
                            // no touch input would be reponsed.      
        window_sz = 0;
        memset(tmptr, 0, TRIGGER_LEN);
        pcinput = 1;
        pc.putc(tmp_char);
    } else if (tmp_char == '0' || tmp_char == '1') {
        if (pcinput && tmp_len != TRIGGER_LEN - 1) {
            tmptr[tmp_len++] = tmp_char;
            pc.putc(tmp_char);
        } else {
            // It is not time for input now.
            pc.printf("HOST ERROR\n\r");
        }
    } else if (tmp_char == 'E') {
        if (tmp_len == 0) {
            pc.printf("HOST ERROR\n\r");
        } else {
            pcinput = 0;
            match_len = 0;
            tmptr[tmp_len] = '\0';
            memcpy(trigger, tmptr, TRIGGER_LEN);
            tr_len = tmp_len;
            pc.putc(tmp_char);
            pc.printf("\n\rThe trigger string is %s\n\r", trigger);
            pc.printf("Please start to touch the button\n\r");
            pc.printf("Or you can the trigger string in the format of Sbbb...bbbE\n\r");
        }
    } else if (tmp_char == ' ') {
        // Simply ignore the whitespace
    } else {
        // Invalid input
        if (pcinput) {
            pc.printf("\n\rHOST ERROR\n\rS");
            for (int i = 0; i < tmp_len; i++) {
                pc.putc(tmptr[i]);
            }
        } else {        
            pc.printf("HOST ERROR\n\r");
        }
    }
}


int buttonTouched() {
    key = readTouchInput();
    return 1;
}

int touchSense_1(void) {
    float sample;
    ground_1 = 0;
    charger_1.mode(PullUp);
    charger_1.mode(PullNone);
    sample=input_1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int touchSense_2(void) {
    float sample;
    ground_2 = 0;
    charger_2.mode(PullUp);
    charger_2.mode(PullNone);
    sample=input_2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

/*
 * In this implementation, "multicouch" is naturely not supported.
 * When two button is touch at the same time, '0' will be always returned
 * instead of '1'.
 */
char readTouchInput() {
    while (1) {
        if (touchSense_1()) {
            myled_1 = 1;
            if (!last_1) {
                last_1 = 1;
                buff_1 = NBUFF;
            }
        } else {
            if (last_1) {
                last_1 = 0;
            } else {
                if (buff_1 == 0) {
                    if (myled_1) {
                        myled_1 = 0;
                        return '0';
                    }
                } else {
                    buff_1--;
                }
            }
        }
        if (touchSense_2()) {
            myled_2 = 1;
            if (!last_2) {
                last_2 = 1;
                buff_2 = NBUFF;
            }
        } else {
            if (last_2) {
                last_2 = 0;
            } else {
                if (buff_2 == 0) {
                    if (myled_2) {
                        myled_2 = 0;
                        return '1';
                    }
                } else {
                    buff_2--;
                }
            }
        }
        wait(0.005);
    }
}

int isIdentity(char* cp1, char* cp2, size_t len) {
    for (int i = 0; i != len; i++) {
        if (cp1[i] != cp2[i]) {
            return 0;
        }
    }
    return 1;
}

void windowShift(char* wpt, size_t len) {
    for (int i = 0; i != len - 1; i++) {
        wpt[i] = wpt[i + 1];
    }
}

void printDetectWindow(char* wpt, size_t len) {
    pc.printf("Current detection window: ");
    for (int i = 0; i != len; i++) {
        pc.putc(wpt[i]);
    }
    pc.printf("\n\r");
}