#include "mbed.h"

#define NBUFF 10

typedef enum {s_0, s_HI, s_HE, s_WD, s_WI, s_TE, s_M} State_t;
typedef enum {e_InvalidInput, e_ValidInput, e_DetectMatch, e_Start, e_1, e_0, e_E} Event_t;

int touchSense_1(void);
int touchSense_2(void);
void handleEvent(Event_t ev);
void entry_HI();
void entry_HE();
void entry_WD();
void entry_WI();
void entry_TE();
void entry_M();
char readTouchInput();

DigitalOut myled_1(LED1);
DigitalOut myled_2(LED2);
AnalogIn input_1(p17);
AnalogIn input_2(p20);
DigitalIn charger_1(p16);
DigitalIn charger_2(p19);
DigitalOut ground_1(p15);
DigitalOut ground_2(p18);
Serial pc(USBTX, USBRX); // tx, rx

State_t state;
Event_t currentEv;
char trigger[128];
int tr_len, tr_pos;

int buff_1, buff_2;
int last_1, last_2;

int main() {
    state = s_0;
    currentEv = e_Start;
    trigger[0] = '\0';
    tr_len = 0;
    while (1) {
        handleEvent(currentEv);
    }
}

int touchSense_1(void) {
    float sample;
    ground_1 = 0;
    charger_1.mode(PullUp);
    charger_1.mode(PullNone);
    sample=input_1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int touchSense_2(void) {
    float sample;
    ground_2 = 0;
    charger_2.mode(PullUp);
    charger_2.mode(PullNone);
    sample=input_2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

void emitEvent(Event_t ev) {
    currentEv = ev;
}

void handleEvent(Event_t ev) {
    switch (state) {
        case s_0:
            if (ev == e_Start) {
                state = s_HI;
                entry_HI();
            }
            break;
        case s_HI:
            if (ev == e_ValidInput) {
                state = s_WD;
                entry_WD();
            } else if (ev == e_InvalidInput) {
                state = s_HE;
                entry_HE();
            }
            break;
        case s_HE:
            state = s_0;
            break;
        case s_WD:
            if (ev == e_0 || ev == e_1) {
                entry_WD();
            } else if (ev == e_E) {
                state = s_WI;
                entry_WI();
            } else {
                state = s_HE;
                entry_HE();
            }
            break;
        case s_WI:
            if (ev == e_InvalidInput) {
                state = s_TE;
                entry_TE();
            } else if (ev == e_DetectMatch) {
                state = s_M;
                entry_M();
            }
            break;
        case s_TE:
            state = s_0;
            break;
        case s_M:
            state = s_0;
            break;
        default:
            state = s_0;
    }
}

void entry_HI() {
    tr_len = 0;
    pc.printf("Please input the trigger string in the format of Sbbb...bbbE\n\r");
    if (pc.getc() == 'S') {
        emitEvent(e_ValidInput);
    } else {
        emitEvent(e_InvalidInput);
    }
}

void entry_WD() {
    switch (pc.getc()) {
        case '0':
            trigger[tr_len++] = '0';
            pc.putc('0');
            emitEvent(e_0);
            break;
        case '1':
            trigger[tr_len++] = '1';
            pc.putc('1');
            emitEvent(e_1);
            break;
        case 'E':
            if (tr_len == 0) {
                emitEvent(e_InvalidInput);
            } else {
                emitEvent(e_E);
                pc.putc('\n');
                pc.putc('\r');
                trigger[tr_len] = '\0';
            }
            break;
        case ' ':
            pc.putc(' ');
            break;
        default:
            emitEvent(e_InvalidInput);
    }
}

void entry_HE() {
    pc.printf("\n\rHOST ERROR\n\r");
    emitEvent(e_Start);
}

void entry_WI() {
    buff_1 = NBUFF;
    buff_2 = NBUFF;
    last_1 = 0;
    last_2 = 0;
    tr_pos = 0;
    pc.printf("The trigger string is %s\n\r", trigger);
    pc.printf("Please start to touch the button\n\r");
    while (tr_pos < tr_len) {
        if (readTouchInput() != trigger[tr_pos]) {
            emitEvent(e_InvalidInput);
            return;
        }
        pc.putc(trigger[tr_pos++]);
    }
    pc.putc('\n');
    pc.putc('\r');
    emitEvent(e_DetectMatch);
}

char readTouchInput() {
    while (1) {
        if (touchSense_1()) {
            myled_1 = 1;
            if (!last_1) {
                last_1 = 1;
                buff_1 = NBUFF;
            }
        } else {
            if (last_1) {
                last_1 = 0;
            } else {
                if (buff_1 == 0) {
                    if (myled_1) {
                        myled_1 = 0;
                        return '0';
                    }
                } else {
                    buff_1--;
                }
            }
        }
        if (touchSense_2()) {
            myled_2 = 1;
            if (!last_2) {
                last_2 = 1;
                buff_2 = NBUFF;
            }
        } else {
            if (last_2) {
                last_2 = 0;
            } else {
                if (buff_2 == 0) {
                    if (myled_2) {
                        myled_2 = 0;
                        return '1';
                    }
                } else {
                    buff_2--;
                }
            }
        }
        wait(0.005);
    }
}

void entry_TE() {
    pc.printf("\n\rTOUCH ERROR\n\r");
    emitEvent(e_Start);
}

void entry_M() {
    pc.printf("MATCH\n\r");
    emitEvent(e_Start);
}