// Project: Nokia5110 - Controlling a NK5110 display from an NXP LPC1768
// File: main.cpp
// Author: Chris Yan
// Created: January, 2012
// Revised:
//  Desc: A basic LCD output test which uses the NXP LPC1768's SPI interface to
//      display pixels, characters, and numbers on the Nokia 5110 LCD.
//      Created using a sparkfun breakout board with integrated Phillips 8544 driver
//      for 48x84 LCDs.

#include "mbed.h"
#include "NOKIA_5110.h"
DigitalIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
int i;
int litera(70);
int main()
{
    // Init the data structures and NokiaLcd class
    LcdPins myPins;
    myPins.sce  = D8;
    myPins.rst  = D9;
    myPins.dc   = D10;
    myPins.mosi = D11;
    myPins.miso = NC;
    myPins.sclk = D13;

    NokiaLcd myLcd( myPins );

    // Start the LCD
    myLcd.InitLcd();
    // Test the LCD
    myLcd.TestLcd( 0xff );
    wait( 0.1 );
myLcd.ClearLcdMem();
    
    

/*
myLcd.SetXY(1,1);
myLcd.DrawString("POL");
myLcd.SetXY(2,2);
myLcd.DrawString("POL");
*/


myLcd.SetXY(1,1);
myLcd.DrawChar(70);
myLcd.SetXY(12,2);
myLcd.DrawChar(71);
myLcd.SetXY(11,13);
myLcd.DrawChar(72);
myLcd.SetXY(212,222);
myLcd.DrawChar(73);



    while( 1 ) {
        /*
                for (i=1; i<197; i++) {
                    myLcd.DrawChar( litera);
                    wait(0.1); //dance
                    if (mybutton == 0) { // Button is pressed
                        myled = !myled; // Toggle the LED state
                       litera++;
                        wait(0.2); // 200 ms
                    }}
        */

    }
}