/**
* Includes
*/
#include "SMC02B.h" 
 
    SMC02B::SMC02B(PinName tx, PinName rx, PinName rst) : _rst(rst)
    {
        _SMC02B = new Serial( tx, rx);
        _rst = 1;
    }

    void SMC02B::SMC02B_RST(void)
    {
        _rst = 1;
        wait(0.1);
        _rst = 0;
        wait(0.1);
        _rst = 1;
        wait(0.1);
    }

    // Set Motor movement
    // motor
    // motor ID
    // direction
    // 0 - Reverse
    // 1 - Forward
    // speed
    // 0 - 127 ( 0x7F )
    void SMC02B::SMC02B_MOTOR_SET( char motor, char direction, char speed )
    {
        char motor_ = motor << 1;
        _SMC02B -> putc( SMC02B_START_BYTE );
        _SMC02B -> putc( SMC02B_DEVICE_ID );
        _SMC02B -> putc( motor_ | direction );    
        _SMC02B -> putc( speed );
    }

    // OFF Backward -> Brake
    void SMC02B::SMC02B_MOTOR_BRAKE( char motor )
    {
        char motor_ = motor << 1;
        _SMC02B -> putc( SMC02B_START_BYTE );
        _SMC02B -> putc( SMC02B_DEVICE_ID );
        _SMC02B -> putc( motor_ | 0x00 );    
        _SMC02B -> putc( 0x00 );
    }

    // OFF Forward -> Coasting
    void SMC02B::SMC02B_MOTOR_COAST( char motor )
    {
        char motor_ = motor << 1;
        _SMC02B -> putc( SMC02B_START_BYTE );
        _SMC02B -> putc( SMC02B_DEVICE_ID );
        _SMC02B -> putc( motor_ | 0x01 );    
        _SMC02B -> putc( 0x00 );
    }

    // Config
    // mode 
    // 0 - 2 Motors
    // 1 - 1 Motor
    // motor
    // 0 - 63 ( 0x3F ) First motor number
    void SMC02B::SMC02B_CONFIG( char mode, char motor )
    {
        char mode_ = mode << 6;
        char motor_ = motor & 0x3F;
        _SMC02B -> putc( SMC02B_START_BYTE );
        _SMC02B -> putc( SMC02B_CONFIG_BYTE );
        _SMC02B -> putc(mode_ | motor_ );    
    }



