#include "Adafruit_MAX31855.h"
#include "mbed.h"

// Default connection is using software SPI, but comment and uncomment one of
// the two examples below to switch between software SPI and hardware SPI:

// Example creating a thermocouple instance with software SPI on any three
// digital IO pins.

#define CS 1

Adafruit_MAX31855 thermocouple(CS);

Serial pc(USBTX, USBRX);
DigitalOut light(p8);

void setup() {
  pc.printf("MAX31855 test\n");
  // wait for MAX chip to stabilize
  wait(0.5);
}

void loop() { // main loop used to transmit data over USB
   double c = thermocouple.readCelsius();
   if (isnan(c)) {
     pc.printf("Something wrong with thermocouple!");
   } else {
     pc.printf("%f", c); 

   }
   wait(0.1);
}

int main(){
    setup();
    while(1){
        wait(0.05);
        light = 0;
        loop();
        wait(0.05);
        light = 1;
        } 
    //return 0;
    }