/*************************************************** 
  This is a library for the Adafruit Thermocouple Sensor w/MAX31855K
  Designed specifically to work with the Adafruit Thermocouple Sensor
  ----> https://www.adafruit.com/products/269
  These displays use SPI to communicate, 3 pins are required to  
  interface
  Adafruit invests time and resources providing this open source code, 
  please support Adafruit and open-source hardware by purchasing 
  products from Adafruit!
  Written by Limor Fried/Ladyada for Adafruit Industries.  
  BSD license, all text above must be included in any redistribution
 ****************************************************/

#include "Adafruit_MAX31855.h"

SPI spi(p5, p6, p7); // mosi, miso, sclk
PwmOut cs(p21);
Serial pc1(USBTX, USBRX); // tx, rx

Adafruit_MAX31855::Adafruit_MAX31855(int8_t CS) {

  hSPI = 1;
  //SPI spi(p5, p6, p7); // mosi, miso, sclk
  spi.format(8,0);
  spi.frequency(1000000);
  cs = 1;
}

double Adafruit_MAX31855::readInternal(void) { //returns the internal temperature of MAX31855
  uint32_t v;

  v = spiread32();
  // ignore bottom 4 bits - they're just thermocouple data
  v >>= 4;

  // pull the bottom 11 bits off
  float internal = v & 0x7FF;
  // check sign bit!
  if (v & 0x800) {
    // Convert to negative value by extending sign and casting to signed type.
    int16_t tmp = 0xF800 | (v & 0x7FF);
    internal = tmp;
  }
  internal *= 0.0625; // LSB = 0.0625 degrees
  return internal;
}

double Adafruit_MAX31855::readCelsius(void) { //returns the thermocouple temperature readout

  int32_t v;
  v = spiread32();

  if (v & 0x7) {
    // uh oh, a serious problem!
    return NAN; 
  }

  if (v & 0x80000000) {
    // Negative value, drop the lower 18 bits and explicitly extend sign bits.
    v = 0xFFFFC000 | ((v >> 18) & 0x00003FFFF);
  }
  else {
    // Positive value, just drop the lower 18 bits.
    v >>= 18;
  }
  double centigrade = v;

  // LSB = 0.25 degrees C
  centigrade *= 0.25;
  return centigrade;
}

uint8_t Adafruit_MAX31855::readError() {
  return spiread32() & 0x7;
}

double Adafruit_MAX31855::readFarenheit(void) {
  float f = readCelsius();
  f *= 9.0;
  f /= 5.0;
  f += 32;
  return f;
}

uint32_t Adafruit_MAX31855::spiread32(void) { 
  int i;
  uint32_t d = 0;

  if(hSPI) {
    return hspiread32();
  }
    pc1.printf("I AM NOT SUPPOSED TO BE HERE");
    sclk = 0;
    wait(0.001);
    cs = 0;
    wait(0.001);

  for (i=31; i>=0; i--)
  {
    sclk = 0;
    wait(0.001);
     d <<= 1;
    if (miso) {
      d |= 1;
    }

    sclk = 1;
    wait(0.001);
  }
    cs = 1;
  return d;
}

uint32_t Adafruit_MAX31855::hspiread32(void) { //gets the bytestream from SPI and convirts it to unsigned int
  int i;
  // easy conversion of four uint8_ts to uint32_t
  union bytes_to_uint32 {
    uint8_t bytes[4];
    uint32_t integer;
  } buffer;

  // Chip must be selected
    cs = 0;
    wait(0.05);
  for (i=3;i>=0;i--) {
    buffer.bytes[i] = spi.write(0x8F);
  }
  cs = 1;
  wait(0.05);
  
  return buffer.integer;
  
}