/*
 * mbed library to use a TAOS TSL2550 Ambient Light Sensor
 * Copyright (c) 2011 Stefan Goeckeritz, 
 * RheinAhrCampus Remagen, Suedallee 2, 53424 Remagen
 * 
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
#ifndef TSL2550_H
#define TSL2550_H

#include "mbed.h"

class TSL2550 : public Base {
public:
    TSL2550(PinName p_sda, PinName p_scl);
    TSL2550(I2C& p_i2c);

    unsigned short get_ch0();
    unsigned short get_ch1();    
    double get_lux();
    void update();

protected:
    void init();
    unsigned short twi_read (unsigned short, unsigned short);
    void twi_write (unsigned short, unsigned short);

    I2C i2c;

private:
    double lux;
    unsigned short ch0, ch1;
};

#endif