/* mbed SRF02 Ultra Sonic Range Finder Library
 * Copyright (c) 2011 by djoshi [go2dev]
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 *to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *copies of the Software, and to permit persons to whom the Software is
 *furnished to do so, subject to the following conditions:
 *
 *The above copyright notice and this permission notice shall be included in
 *all copies or substantial portions of the Software.
 *
 *THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *THE SOFTWARE.
 */


/*Header file for the SRF02 sonar range finder class*/
#ifndef SRF02_H
#define SRF02_H

#include "mbed.h"

//!Library for the SRF02 Ultrasonic Ranger
/*
 * The SRF02 is an I2C Ultrasonic rangefinder which can return values for measured
 * distance as either time of flight (uS) or directly in cm or in.

 * Example Usage:
 * @code
 * //Take a measurement of the current distance (in cm), print the result to the terminal via the debug port
 * #include "mbed.h"
 * #include "SRF02.h"
 *
 * Serial debugport(USBTX,USBRX);
 * SRF02 mySensor(p9,p10,0xE0);
 * main() {
 *  while (1) {
 *      debugport.printf("current distance: %.2f cm. \r\n", mySensor.measurecm());
 *  }
 * }
 * @endcode
*/

*/

class SRF02 {
public:
    /** Create a SRF02 object connected to the specified I2C pins
    *
    * @param sda I2C Data pin to connect to
    * @param scl I2C Clock pin to connect to
    */
    SRF02(PinName sda, PinName scl, int addr);

    /** Destroys an instance of SRD02
    */
    ~SRF02();

    /** Get the current distance in centimetres
    *
    * @param returns the measured distance in centimetres as a float
    */
    float measurecm();

    /** Get the current distance in centimetres
    *
    * @param returns the measured distance in inches as a float
    */
    float measurein();

    /** Get the current distance in centimetres
    *
    * @param returns the time of flight from the pulse sent from the sensor in microseconds (uS) as a float
    */
    float measureus();


private:
    I2C m_i2c;
    int m_addr;

    /** dosonar is an internal function for this library which actually manages the I2C transaction with the sensor to get a reading.
     * It is not directly accessible by the user via the libaray
    */
    float dosonar(char rangetype);


};
#endif