/*Header file for the SRF02 sonar range finder class*/
#ifndef SRF02_H
#define SRF02_H

#include "mbed.h"

//!Library for the SRF02 Ultrasonic Ranger
/*!
The SRF02 is an Ultrasonic range finder, with an I2C interface that allows the measurement to be read directly in centimetres
*/

class SRF02
{
public:
    //Create an instance of the class
    //Connect the peripheral over I2C using pins defined by sda and scl
    SRF02(PinName sda, PinName scl, int addr);
    
    //Destroys an instance
    ~SRF02();
    
    //Read the distance in cm
    float distancecm();
    
    //Read the distance in in
    float distancein();
    
    //Read the distance in microseconds
    float distanceus();


private:
    I2C m_i2c;
    int m_addr;
    
    
};
#endif