#define SAMPLE_RATE     750000
#define LENGTH_RESULT   100

#include "mbed.h"
#include "adc.h"

//Initialise ADC to maximum SAMPLE_RATE and cclk divide set to 1
ADC adc(SAMPLE_RATE, 1);

Serial uart(USBTX, USBRX);  // tx, rx
volatile int result[LENGTH_RESULT];

int main() {
    // Init UART
//    uart.baud(256000);
//    uart.printf("Requested max sample rate is %u, actual max sample rate is %u.\n", SAMPLE_RATE, adc.actual_sample_rate());

    //Set up ADC on pin 20
    adc.setup(p20,1);
    //Measure pin 20
    adc.select(p20);    

    // Vars
    
       int count;
     // Program
    
    // AD conversion
    for(count = 0; count < LENGTH_RESULT; count++){
        //Start ADC conversion
        adc.start();
        //Wait for it to complete
        while(!adc.done(p20));
        result[count] = adc.read(p20); 
    }
    // Send over UART
    for(count = 0; count < LENGTH_RESULT; count++){      
        uart.printf("%04u.\n", result[count]);
    }
}



