#include "mbed.h"

InterruptIn fireIrq(p14);
Timeout timeoutIrq;

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial pc(USBTX, USBRX);


// funktion runs in interrupt-context
void fireIrqHandler( void )
{
    led1 = !led1;
    pc.printf("Starting up...\n\r");
}

// runs in irq-context
void timeoutIrqHandler( void )
{
    led2 = 0;   
}

int main()
{
    pc.printf("Starting up...\n\r");
    
    fireIrq.fall( &fireIrqHandler );
    fireIrq.rise( &fireIrqHandler );
    
    led2 = 1;
    timeoutIrq.attach( &timeoutIrqHandler, 3 );
    
    while(1) {
        wait(5);
    }
}