#ifndef __I2C_SLAVE_COMM__
#define __I2C_SLAVE_COMM__

#define MAX_WRITE_SIZE 8
#include "mbed.h"


class I2CSlaveCustom : public I2CSlave
{
    public:

    I2CSlaveCustom(PinName sda, PinName scl) : I2CSlave(sda, scl)
    {

    }

    int getCount()
    {
        int result = _i2c.i2c.handle.XferSize;
        if (result > MAX_WRITE_SIZE || result < 0)
            return 0;
        return result;
    }


};


void InitI2CSlaveComm();
void I2CSlaveProcess();
void setTension(double value);
void flow();
void cycle();
void commandselect();
void setStartingValue();
void resetCycle();

#endif
