/*******************************************************************************
 * Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#ifndef SOURCE_DEMOUI_DEMOUI_H_
#define SOURCE_DEMOUI_DEMOUI_H_

#include <events/mbed_events.h>
#include <mbed.h>

#include "screen/LS013B7DH03.h"

enum{
	DISPLAY_WHRM  = 0,
	DISPLAY_WSPo2 = 1
};

#define USE_DEMO_DISPDEV
#if defined(USE_DEMO_DISPDEV)


	void demoUI_init();
	void demoUI_display_algo_estimations(int integer);
	void demoUI_display_set_algoMode(int algo);
	int demoUI_display_get_mode(void);
	void demoUI_display(int algoResult);



#else
	void start_demo_display(void);
	void display_algo_estimations( uint8_t mode , int integer, int fraction);
	void setup_mode_button(void);

#endif


extern volatile uint8_t algoMode;

#endif /* SOURCE_DEMOUI_DEMOUI_H_ */
