/*
 * mbed library to use a Bosch Sensortec MS5611 sensor
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
/** @file MS5611.h
 * @brief mbed library to use a Bosch Sensortec MS5611 sensor
 * barometric pressure sensor MS5611 (Bosch Sensortec)
 * interface: I2C digital
 */
 
#ifndef MS5611_H
#define MS5611_H

#include "mbed.h"

/**
 * @brief over sampling setting
 */
enum MS5611_oss {
    MS5611_oss1 = 0, ///< ultra low power (1 time)
    MS5611_oss2 = 1, ///< standard (2 times)
    MS5611_oss4 = 2, ///< high resolution (4 times)
    MS5611_oss8 = 3  ///< ultra high resolution (8 times)
};

/**
 * @brief MS5611 class
 */
class MS5611 
{
public:
    MS5611(PinName p_sda, PinName p_scl, MS5611_oss p_oss = MS5611_oss1);
    MS5611(I2C& p_i2c, MS5611_oss p_oss = MS5611_oss1);

    float get_temperature();
    float get_pressure();
    void update();

protected:
    void init(MS5611_oss);
    unsigned short twi_readshort (int, int);
    unsigned long twi_readlong (int, int);
    void twi_writechar (int, int, int);

    I2C i2c;
    float temperature;
    float pressure;

private:

    short ac1, ac2, ac3, b1, b2, mb, mc, md, oss;
    unsigned short ac4, ac5, ac6;
};

#endif