#include "mbed.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "Mlx90615.h"
#include "TMP117.h"
#include "PinDetect.h"
#include <cstdio>
 
#define LOG_DELAY 1 //seconds
#define TMP_QUANT 1 // MAX = 4
#define MLX_QUANT 1 // MAX = 127 (NEED TO BE CORRECT ON SETUP)
#define MLX_SETUP 0 // 1=Setup or 0=LOG


DigitalOut myled(LED1);
DigitalOut led2(LED2);

int volatile quit = 0;

void 
buttonISR()
{
    quit = !quit;
}

int
main()
{
    // set_time(1595446700 - 3600*4); // set time to 22/07/2020 15:38:20 @CGMS
    
    
    if(MLX_SETUP)
    {
        PinDetect button(p11);
        // Use internal pullup for pushbutton
        button.mode(PullUp);
        // Delay for initial pullup to take effect
        ThisThread::sleep_for(10);
        // Setup Interrupt callback function for a button hit
        button.attach_deasserted(&buttonISR);
        // Start sampling button input using interrupts
        button.setSampleFrequency(); 
        Mlx90615 mlx{MLX_QUANT};
        int lastbutton = quit;
        for(int i = 0; i < MLX_QUANT; i++)
        {
            led2=1;
            while(lastbutton==quit);
            led2=0;
            lastbutton = quit;
            printf("write slave addr %d\n", i+1);
            mlx.write_eeprom_address(0x00, (uint16_t)i+1, 0x00); //all mlx will ACK to 0x00
        }
    }
    else
    {
        printf("Entering log mode\n");
        while (!quit) 
        {   
            //Os objetos que bloqueiam sleep(I2C, SPI) não estão declarados, então o sleep no começo deveria funcionar
            ThisThread::sleep_for(LOG_DELAY*1000);
            PinDetect button(p11);
            // Use internal pullup for pushbutton
            button.mode(PullUp);
            // Delay for initial pullup to take effect
            ThisThread::sleep_for(10);
            // Setup Interrupt callback function for a button hit
            button.attach_deasserted(&buttonISR);
            // Start sampling button input using interrupts
            button.setSampleFrequency(); 

            Mlx90615 mlx{MLX_QUANT};
            TMP117 tmp(0x48);
            SDBlockDevice blockDevice(MBED_CONF_SD_SPI_MOSI,
                            MBED_CONF_SD_SPI_MISO,
                            MBED_CONF_SD_SPI_CLK,
                            MBED_CONF_SD_SPI_CS);
            FATFileSystem fileSystem("fs");

            printf("Mounting SDcard...\n");printf("Mounting the filesystem... ");
            fflush(stdout);

            int err = fileSystem.mount(&blockDevice);
            printf("%s\n", (err ? "Fail :(" : "OK"));
            if (err) 
            {
                // Reformat if we can't mount the filesystem
                // this should only happen on the first boot
                printf("No filesystem found, formatting... ");
                fflush(stdout);
                err = fileSystem.reformat(&blockDevice);
                printf("%s\n", (err ? "Fail :(" : "OK"));
                if (err) {
                    error("error: %s (%d)\n", strerror(-err), err);
                }
            }
            printf("SD mount done.\n");

            FILE *fp = fopen("/fs/log.csv","a+");
            if(fp == nullptr)
            {
                printf("Could not open file\n");
                while(1);
            }

            myled = 1;
            time_t seconds = time(NULL);
            
            mlx.read_temperatures();
            tmp.getTemperatures();
  
            printf("%s",ctime(&seconds));
            printf("{\nTMP:\n");
            fprintf(fp, "%s",ctime(&seconds));
            for(int i = 0; i < TMP_QUANT; i++)
            {
                printf("\t%d: %.2f ,", i, tmp.temps[i]);
                fprintf(fp, ", %.2f", tmp.temps[i]);
            }
            printf("\nMLX:\n");
            for(int i = 0; i < MLX_QUANT; i++)
            {
                printf("\t%d: %.2f ,", i, mlx.temps[i]);
                fprintf(fp, ", %.2f", mlx.temps[i]);
            }
            printf("\n}\n");
            fprintf(fp,"\n");
            
            fflush(fp);
            myled = 0;
            
            // Close the file which also flushes any cached writes
            err = fclose(fp);
            printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
            if (err < 0)
                error("error: %s (%d)\n", strerror(errno), -errno);
            

            // Tidy up
            printf("Unmounting... ");
            fflush(stdout);
            err = fileSystem.unmount();
            printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
            if (err < 0) {
                error("error: %s (%d)\n", strerror(-err), err);
            }

            //os objetos que bloqueiam o sleep(I2C e SPI) são destruídos aqui
        }
    }
    printf("Goodbye World!\n");
}
