#include "mbed.h"

#ifndef __MLX_h
#define __MLX_h
#define EEPROM 0x10
#define RAM 0x20
    
#define MLX_SDA p28
#define MLX_SCL p27

extern DigitalOut MLX_VCC;

class Mlx90615
{
public:
         Mlx90615(int quant);
    void wake();
    void sleep();
    void erase_eeprom_address(unsigned char reg_addr, unsigned char mlx_addr);
    void write_eeprom_address(unsigned char reg_addr, uint16_t data, unsigned char mlx_addr);
    void set_emissivity(float e, unsigned char mlx_addr);
    float read_temperature(unsigned char mlx_addr); 
    void read_temperatures(); 
    float temps[127] { 0 };
    I2C i2c{MLX_SDA, MLX_SCL};//I2C_SDA, I2C_SCL 
private:
    int n_mlx;
    void _write(unsigned char reg_addr, uint16_t value, unsigned char mlx_addr);
    float _read(unsigned char memory, unsigned char reg_addr, unsigned char mlx_addr);
};

#endif // __MLX_h