
#include "Mlx90615.h"

MbedCRC<POLY_8BIT_CCITT , 8>ct;


Mlx90615::Mlx90615(int quant):
    n_mlx{quant}
{
    //do nothing
}

inline void 
Mlx90615::wake()
{
	/*SCL = 0;
	wait_ms(50);
	SCL = 1;*/
	MLX_VCC = 1;
	ThisThread::sleep_for(301);//Waiting for valid data as datasheet says
}

inline void 
Mlx90615::sleep(){
	MLX_VCC = 0;
}

float 
Mlx90615::_read(unsigned char memory, unsigned char reg_addr, unsigned char mlx_addr){
	unsigned char crc, addr, status = 0;
	char read[2];
    int ACK = 0;

	addr = memory + reg_addr;

    read[0] = 0x01;
    read[1] = 0x00;
	
    char cmd = 0x27;
	Mlx90615::i2c.start();
	ACK = Mlx90615::i2c.write(mlx_addr<<1);
	if(!ACK) return -1;
    ACK = Mlx90615::i2c.write(addr);
	if(!ACK) return -1;
	Mlx90615::i2c.start();
    ACK = Mlx90615::i2c.write((mlx_addr<<1)|1);
	if(!ACK) return -1;
    read[0] = Mlx90615::i2c.read(ACK);
    if(!ACK) return -1;
    read[1] = Mlx90615::i2c.read(ACK);
    Mlx90615::i2c.read(ACK);
	float temp = (float((read[1] << 8) | read[0]));
	return temp;
}

float 
Mlx90615::read_temperature(unsigned char mlx_addr)
{
	float temp = _read(RAM, 0x07, mlx_addr);
    int cont = 0;
	while(temp == 0)
	{
        if(cont == 100)
        {
            cont = 0;
        }
		wait_us(5000);
		temp = _read(RAM, 0x07, mlx_addr);
        cont++;
	}
	return temp*0.02 - 273.15;
}

void 
Mlx90615::read_temperatures()
{
    for(int i = 0; i < n_mlx; i++)
        temps[i] = read_temperature(i+1);
}

void 
Mlx90615::_write(unsigned char reg_addr, uint16_t value, unsigned char mlx_addr)
{
	unsigned char addr = EEPROM + reg_addr;
	char bytes[4];
    uint32_t mcrc;
    unsigned char crc, vh, vl;
	vh = value >> 8;
	vl = value;
	bytes[0] = 0x00;
	bytes[1] = addr;
	bytes[2] = vl;
	bytes[3] = vh;
	ct.compute((void*)bytes, 4, &mcrc);

    crc = mcrc & 0xff;
    Mlx90615::i2c.start();
    Mlx90615::i2c.write(0x00<<1);
	Mlx90615::i2c.write(addr);
	Mlx90615::i2c.write(vl);
    Mlx90615::i2c.write(vh);
	Mlx90615::i2c.write(crc);
    Mlx90615::i2c.stop();
    ThisThread::sleep_for(300);
}

void 
Mlx90615::erase_eeprom_address(unsigned char reg_addr, unsigned char mlx_addr){
	_write(reg_addr, 0x0000, mlx_addr);
}

void 
Mlx90615::write_eeprom_address(unsigned char reg_addr, uint16_t data, unsigned char mlx_addr)
{
    if(reg_addr>= 0x04 && reg_addr <=0x0d)
        return;
    Mlx90615::erase_eeprom_address(reg_addr, mlx_addr);
    Mlx90615::_write(reg_addr, data, mlx_addr);
}

void 
Mlx90615::set_emissivity(float e, unsigned char mlx_addr){
	unsigned int emissivity;
	emissivity = 16384 * e;
	erase_eeprom_address(0x03, mlx_addr);
	ThisThread::sleep_for(5);
	_write(0x03, emissivity, mlx_addr);
}
