#include "mbed.h"
#include "Stepper_motor.h"
#include "esp8266.h"
#include <cstdarg>
#include <cstring>

//                en  step  dir button 减速比 细分数 初始方向
Stepper_motor s1(PB_9,PB_0,PB_7,PC_15,10,16,1);
Stepper_motor s2(PB_6,PA_7,PB_4,PB_13,10,16,1);
Stepper_motor s3(PB_3,PA_6,PA_12,PB_5,10,16,0);
DigitalOut air(PC_13);
Serial ser2usb(PB_10, PB_11, 115200); 
int stepok = 0;
int actionok = 0;
int state;
int high;
int main()
{ 
        s1.Init();
        wait(5);
        s2.Init();
        wait(5);
        s3.Init();
        wait(5);
     ser2usb.printf("starting\r\n");
    
    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    Esp8266 client(PA_9, PA_10, "iot_b827ebd838be", "ab087c9e");// 参数分别为 TX pin / RX pin / SSID / Password

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "actionok", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "do", "int",
        "high","int",
        NULL, NULL //最后一行以空指针作为结束标记
    };
    ser2usb.printf("connecting...\r\n");

    //连接到服务器
    client.connect_mqtt_broker("192.168.12.1", "warehouse", sensors, actuators);

    ser2usb.printf("Initialization done.\r\n");

    char actuator_name[32], control_value[32];
    while(1) {
        //检查有没有收到新的执行器控制指令
        if(client.get_control_cmd(actuator_name, control_value)){
            ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
            //判断哪个执行器收到命令
            if (actuator_name == "high")
            {
                high = atoi(control_value);
            }
            else if(actuator_name == "do")
            {
                state = atoi(control_value);
                switch (state)
                {
                    case 1: //forward1
                        s2.Config(10,10);
                        break;
                    case 2: //back1
                        s2.Config(-10,10);
                    case 3: //forward2
                        s2.Config(10,20);
                    case 4: //back2
                        s2.Config(-10,20);
                    case 5:
                        s3.Config(10,20);   //到方块上方
                        wait(3);
//                        s1.Config(high,30); //下降
//                        wait(4);
//                        air = 1;            //开气泵
//                        s1.Config(-high,30);//上升
//                        wait(3);
//                        s3.Config(-10,20);  //到小车上方
//                        wait(3);
//                        s1.Config(20,20);   //下降
//                        wait(3);                  
//                        air = 0;            //关气泵
//                        wait(2);
//                        s1.Config(-20,20);  //上升 
                        client.publish_value("actionok", "0");   
                    case 6:
                        s1.Config(20,20);   //下降
                        wait(3);                  
//                        air = 1;            //开气泵
//                        wait(2);
//                        s1.Config(-20,20);  //上升
//                        wait(3);
//                        s3.Config(10,20);   //到方块上方
//                        wait(3);
//                        s1.Config(high,30); //下降
//                        wait(4);
//                        air = 0;            //关气泵
//                        s1.Config(-high,30);//上升
//                        wait(3);
//                        s3.Config(-10,20);  //到小车上方
                        client.publish_value("actionok", "0");
                    default:
                        break;
                    
                }
            }
        }
        if (stepok == 1)
        {
            switch (state)
            {
                case 1: 
                case 2: 
                case 3:
                case 4:
                    client.publish_value("actionok", "0");
                    stepok = 0; 
                    break;                
                default:
                    break;
                
            }
            actionok = 0;
        }
}
}
