#include "a4988.h"
#include "mbed.h"

Stepper::Stepper(PinName _en, PinName _stepPin, PinName _direction) : en(_en),
                                                                      stepPin(_stepPin),
                                                                      direction(_direction)
{
}
/**
 * 转动特定脉冲
 * @param dir          [运动方向]
 * @param frequency    [脉冲周期]
 * @param _remain      [脉冲个数]
 */
void Stepper::step(int dir, int frequency, volatile int _remain)
{
    if (dir == 1)
    {
        direction = 0;
    }
    else if (dir == 0)
    {
        direction = 1;
    }
    else
    {
        return;
    }
    remain = _remain;
    step_ticker.attach(callback(this, &Stepper::step_control), 0.5 / frequency);
}
/**
 * 启动步进电机
 */
void Stepper::enable()
{
    en = 0;
}
/**
 * 关闭步进电机
 */
void Stepper::disable()
{
    en = 1;
}
/**
 * 步进电机控制程序
 */
void Stepper::step_control()
{
    if (remain <= 0)
    {
        step_ticker.detach();
        return;
    }

    if (stepPin)
    {
        stepPin = 0; //STEP 1->0
        remain--;
    }
    else
    {
        stepPin = 1; //STEP 0->1
    }
}
/**
 * 一直转
 * @param dir          [运动方向]
 * @param frequency    [脉冲周期]
 */
void Stepper::longrun(int dir, int frequency)
{
    if (dir == 1)
    {
        direction = 0;
    }
    else if (dir == 0)
    {
        direction = 1;
    }
    else
    {
        return;
    }
    step_ticker.attach(callback(this, &Stepper::run_control), 0.5 / frequency);
}
/**
 * 一直转运动函数
 */
void Stepper::run_control()
{
    if (stepPin)
    {
        stepPin = 0; //STEP 1->0
        remain--;
    }
    else
    {
        stepPin = 1; //STEP 0->1
    }
}
/**
 * 停止一直转
 */
void Stepper::stoprun()
{
    step_ticker.detach();
}
