/*-----------------------------------------------------
 File Name : main.cpp
 Purpose : For esp8266 mbed porting
 Creation Date : 22-06-2017
 Last Modified :
 Created By : Jeasine Ma [jeasinema[at]gmail[dot]com]
-----------------------------------------------------*/
#include <cstdarg>
#include <cstring>
#include "mbed.h"
#include "esp8266.h"

Serial ser2usb(PA_2, PA_3, 115200);
DigitalIn ref(PA_12);
DigitalOut LED(PC_13);


//   PA_6   P3  从下往上第二个舵机   1ms   往后倒90度   1.5ms   往后倒45度    2ms 笔直
//   PB_1   P6  从下往上第四个舵机   2ms  张开      1.5ms  中间  1ms  完全合上
//   PA_7   P4  从下往上第一个舵机   1.5ms   从正前方看往右偏45度  1ms    正中间   2ms 右偏度
//   PB_0   P5  从下往上第三个舵机    1.5 中间      1  往后45度  2  往前45


PwmOut mypwm1(PA_7);
PwmOut mypwm2(PA_6);
PwmOut mypwm3(PB_0);
PwmOut mypwm4(PB_1);



int main(void) {
    ser2usb.printf("starting\r\n");
    
    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    Esp8266 client(PA_9, PA_10, "iot_b827ebd838be", "ab087c9e");// 参数分别为 TX pin / RX pin / SSID / Password

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "light", "lx",
        "reflection"," ",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "led", "int",
        NULL, NULL //最后一行以空指针作为结束标记
    };
    ser2usb.printf("connecting...\r\n");

    //连接到服务器
    client.connect_mqtt_broker("192.168.12.1", "alpha", sensors, actuators);

    ser2usb.printf("Initialization done.\r\n");

    char actuator_name[32], control_value[32];
    bool ref_last;
    float last_report=0;
    Timer t;// 定时器用于计量发送传感器数据的时间
    t.start();

    while(1) {
        //检查有没有收到新的执行器控制指令
        if(client.get_control_cmd(actuator_name, control_value)){
            ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
            //判断哪个执行器收到命令
            if(strcmp(actuator_name, "led")==0){
                mypwm1.period_ms(20);
                mypwm2.period_ms(20);
                mypwm3.period_ms(20);
                mypwm4.period_ms(20);
                
                
                mypwm1.pulsewidth(0.001);
                wait(0.5);
                mypwm1.pulsewidth(0.0015);
                wait(0.5);
                mypwm1.pulsewidth(0.002);
                wait(0.5);
                mypwm1.pulsewidth(0.0015);
                wait(0.5);
                mypwm1.pulsewidth(0.001);
                wait(0.5);
                
                mypwm3.pulsewidth(0.001);
                wait(0.5);
                mypwm3.pulsewidth(0.0015);
                wait(0.5);
                
                mypwm4.pulsewidth(0.001);
                wait(0.5);
                mypwm4.pulsewidth(0.0015);
                wait(0.5);
                mypwm4.pulsewidth(0.002);
                wait(0.5);
                
                 mypwm3.pulsewidth(0.0015);
                wait(0.5);
                }
        }
        
        bool reflection = ref;
        if(reflection != ref_last){ //仅在传感器发生变化时汇报数据
        
            ref_last = reflection;

            char val[4];
            sprintf(val, "%d", (int)reflection);
            
            //汇报传感器数据，两个参数分别是传感器名字和值
            client.publish_value("reflection", val);
        }

        if(t.read() - last_report > 1){ // 每1s发送汇报一次传感器数据

            //汇报传感器数据，两个参数分别是传感器名字和值
            //client.publish_value("light", "30 lx");
            
            last_report = t.read();
        }
    }
}
