#include "mbed.h"
#include "string"
#include "stdlib.h"
#include "TermControl.h"

using namespace std;

DigitalOut led1(LED1);
Serial pcEstagio(USBTX, USBRX);
Serial pcBola(USBTX, USBRX);
Serial pcPlataforma(USBTX, USBRX);
AnalogIn   controle(A0);
AnalogIn   controleY(A1);

const int linhas = 30;
const int colunas = 70;

int NumBlocos = 18;
int velocidade = 250;

int blocos[linhas][colunas];

int bolaY = linhas-3;
int bolaX = colunas/2;

int direcaoX = 1;
int direcaoY = -1;

int linhaPlataforma = linhas-2;
int colunaPlataforma = (colunas/2)-4;

void desenhaBlocos(){
    TermControl ctrl;
    
    ctrl.SetTerminal(&pcEstagio);
    for(int i=5;i<=11;i+=3){
        for(int j=5;j<=70;j+=11)
        {
            for(int k = 0;k<6;k++){
                ctrl.PrintAt(j+k, i,"\x1B[31m▒");
                blocos[i][j+k]=1;
            }
        }
    }
    NumBlocos = 18;
}


void desenhaEstagio(){
    TermControl ctrl;
    ctrl.SetTerminal(&pcEstagio);
    ctrl.Reset();
    ctrl.Clear();

    
    string linhaSuperior = "┌";
    
    for(int i=1;i<colunas-1;i++){
        linhaSuperior += "─"; 
    }
    
    linhaSuperior+= "┐";
    
    ctrl.PrintAt(0,0,linhaSuperior);
    
    for(int i=2;i<linhas-1;i++){
        ctrl.PrintAt(0, i, "│");
        ctrl.PrintAt(colunas, i, "│");
    }      
    
    bolaY = linhas-3;
    bolaX = colunas/2;

    ctrl.SetCursor(0, linhaPlataforma);
    ctrl.EraseLine ();
    
    ctrl.PrintAt(colunaPlataforma, linhaPlataforma,"┌──────┐");
    desenhaBlocos();
}

void moverBola(){
    Thread::wait(velocidade);
    
    TermControl ctrl;
    ctrl.SetTerminal(&pcBola);
    
    
    ctrl.PrintAt(bolaX, bolaY, " ");
    
    if(bolaY==2)
       direcaoY*=-1;
    if(bolaX==2 || bolaX==colunas-2)
       direcaoX*=-1;

    if(bolaY==linhas-3)
        if(bolaX>=colunaPlataforma && bolaX<=colunaPlataforma+8){
            direcaoY=-1;
        }
    
    if(bolaY==linhas-2){
            direcaoY=-1;
            direcaoX=1;
            bolaY = linhas-3;
            bolaX = colunas/2;

    }
    else{
        if(blocos[bolaY+direcaoY][bolaX+direcaoX] == 1){
            NumBlocos--;
            int i;
        
            for(i=0;blocos[bolaY+direcaoY][bolaX+direcaoX+i]!=0;i++){
                ctrl.PrintAt(bolaX+direcaoX+i,bolaY+direcaoY," ");
                blocos[bolaY+direcaoY][bolaX+direcaoX+i]=0;
            }
    
            for(i=-1;blocos[bolaY+direcaoY][bolaX+direcaoX+i]!=0;i--){
                ctrl.PrintAt(bolaX+direcaoX+i,bolaY+direcaoY," ");
                blocos[bolaY+direcaoY][bolaX+direcaoX+i]=0;
            }
        
            direcaoY*=-1;
        }
    
        bolaY += direcaoY;
        bolaX += direcaoX;
    }
    
    ctrl.PrintAt(bolaX, bolaY, "O");    
}

static void moverPlataforma(){

    int direcao;
    float seta;
    float setaY;
    
    TermControl ctrl;
    ctrl.SetTerminal(&pcPlataforma);
    
    
    while(true){
        direcao=0;
         Thread::wait(50);
        seta = controle.read();
       
            
        if(seta < 0.2f) {
            direcao=-1;
        } else 
        if(seta > 0.8f){
            direcao=1;
        }
        
        /*
        if(seta=='a'){
            direcao=-1;
        }else if(seta=='d'){
            direcao=1;
        }*/
        
        if(direcao!=0){
          if((colunaPlataforma+direcao)<colunas-7 && (colunaPlataforma+direcao)>1){
            ctrl.SetCursor(0, linhaPlataforma);
            ctrl.EraseLine ();
            colunaPlataforma+=direcao;
            ctrl.PrintAt(colunaPlataforma, linhaPlataforma,"┌──────┐");
          }
        }
    }
   
}


int main() {
    memset(blocos, 0, sizeof(int)*linhas*colunas);
    
    pcEstagio.baud(115200);
    desenhaEstagio();
    Thread t2(moverPlataforma);

    while(true){
        if(NumBlocos==0){
            desenhaEstagio();    
            velocidade = 250*0.5;            
        }
        moverBola();
    }    
    
}