#ifndef TLSSERVER_H
#define TLSSERVER_H

#include "mbed.h"
#include "cyassl/ssl.h"
#include "TLSConnection.h"


class TLSServer : public Socket
{
    public :
        
        TLSServer();
        ~TLSServer();
        
        /** Initialize the server. 
            It listens on port 443, init CyaSSL, load certificates and create CyaSSL context.
        
            \return True if the initializations is completed with success, false otherwise.
        */
        bool init();
          
        /** Accept incoming connection
        
            \return True if it managed to create successfully a new connection, false otherwise.
        */
        bool accept(TLSConnection &con);
        
        
    private :
    
        CYASSL_CTX *_ssl_ctx;
};

#endif
