#include "TLSServer.h"

#pragma once
const static unsigned char deviceCertificate[] = {

  0x30, 0x82, 0x02, 0xad, 0x30, 0x82, 0x02, 0x16, 0xa0, 0x03, 0x02, 0x01,
  0x02, 0x02, 0x02, 0x31, 0x33, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
  0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x67, 0x31, 0x0b,
  0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x47, 0x42, 0x31,
  0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x09, 0x42, 0x65,
  0x72, 0x6b, 0x73, 0x68, 0x69, 0x72, 0x65, 0x31, 0x10, 0x30, 0x0e, 0x06,
  0x03, 0x55, 0x04, 0x07, 0x0c, 0x07, 0x4e, 0x65, 0x77, 0x62, 0x75, 0x72,
  0x79, 0x31, 0x11, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x08,
  0x56, 0x6f, 0x64, 0x61, 0x66, 0x6f, 0x6e, 0x65, 0x31, 0x0c, 0x30, 0x0a,
  0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x03, 0x52, 0x26, 0x44, 0x31, 0x11,
  0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x08, 0x44, 0x4d, 0x53,
  0x65, 0x72, 0x76, 0x65, 0x72, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x33, 0x30,
  0x39, 0x30, 0x33, 0x31, 0x34, 0x30, 0x36, 0x30, 0x39, 0x5a, 0x17, 0x0d,
  0x32, 0x33, 0x30, 0x37, 0x31, 0x33, 0x31, 0x34, 0x30, 0x36, 0x30, 0x39,
  0x5a, 0x30, 0x54, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
  0x13, 0x02, 0x47, 0x42, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04,
  0x08, 0x0c, 0x09, 0x42, 0x65, 0x72, 0x6b, 0x73, 0x68, 0x69, 0x72, 0x65,
  0x31, 0x11, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x08, 0x56,
  0x6f, 0x64, 0x61, 0x66, 0x6f, 0x6e, 0x65, 0x31, 0x0c, 0x30, 0x0a, 0x06,
  0x03, 0x55, 0x04, 0x0b, 0x0c, 0x03, 0x52, 0x26, 0x44, 0x31, 0x10, 0x30,
  0x0e, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x07, 0x44, 0x65, 0x76, 0x69,
  0x63, 0x65, 0x31, 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
  0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8d,
  0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xc8, 0xa8, 0x06, 0x07,
  0x81, 0x24, 0xb0, 0xb6, 0x92, 0x55, 0x87, 0x12, 0x12, 0x54, 0x50, 0x08,
  0xd7, 0x39, 0xce, 0xba, 0xd1, 0xb3, 0x6d, 0xe7, 0xbb, 0x31, 0x8a, 0x30,
  0xa3, 0xb7, 0xfe, 0x1f, 0xea, 0x0d, 0xab, 0x89, 0x22, 0xf2, 0x93, 0xc8,
  0x5b, 0x48, 0xea, 0x73, 0x6f, 0x87, 0xae, 0x70, 0x1d, 0x94, 0x1c, 0x26,
  0xbe, 0x08, 0x9d, 0xb1, 0xd2, 0x7c, 0xc1, 0xe4, 0xb6, 0x8f, 0x5e, 0xbb,
  0x18, 0xe6, 0xb9, 0x19, 0x58, 0xb4, 0xcf, 0x06, 0x6f, 0x3f, 0x35, 0x0a,
  0x0f, 0x94, 0x82, 0x88, 0xb1, 0x1e, 0x17, 0xa5, 0x52, 0x73, 0xa0, 0xf8,
  0x6d, 0x0a, 0x17, 0x6e, 0x7a, 0x39, 0x47, 0x4c, 0x14, 0xfd, 0xdf, 0x9d,
  0x62, 0x48, 0x0f, 0x7f, 0xe9, 0x97, 0x94, 0xc0, 0xb8, 0x8f, 0xb7, 0x76,
  0xf4, 0xf0, 0x1f, 0xf1, 0xc1, 0x66, 0xbc, 0xf9, 0xf7, 0xe3, 0xf0, 0xb7,
  0x66, 0xe5, 0xeb, 0x09, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x7b, 0x30,
  0x79, 0x30, 0x09, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x04, 0x02, 0x30, 0x00,
  0x30, 0x2c, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xf8, 0x42, 0x01,
  0x0d, 0x04, 0x1f, 0x16, 0x1d, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x53, 0x4c,
  0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x43,
  0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x30, 0x1d,
  0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2d, 0x14, 0x06,
  0x43, 0x3c, 0xae, 0xf8, 0x02, 0x0a, 0x1d, 0x21, 0xd8, 0x61, 0xd9, 0x96,
  0x8f, 0xc6, 0xfa, 0x9d, 0xe9, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23,
  0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xaa, 0x27, 0x1a, 0x6f, 0x88, 0x72,
  0x8c, 0x2d, 0x2d, 0xc2, 0x5a, 0xc5, 0x74, 0x82, 0xa5, 0x44, 0xd1, 0x3d,
  0xa3, 0x15, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
  0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x90, 0x07, 0x5b,
  0x99, 0x3c, 0xd4, 0xfe, 0x4f, 0x84, 0x65, 0xa8, 0x3b, 0xd0, 0xa4, 0x2b,
  0xd2, 0xe4, 0x5f, 0xc0, 0x26, 0xaf, 0xbb, 0xb3, 0x4c, 0xad, 0x7d, 0xfb,
  0x12, 0xb9, 0x13, 0x3f, 0x52, 0xee, 0x0b, 0x4f, 0xdf, 0x25, 0xec, 0x53,
  0x29, 0xca, 0xb4, 0xad, 0xf7, 0xbf, 0xaf, 0xa5, 0x4c, 0xd9, 0xea, 0x08,
  0xa9, 0x40, 0x8d, 0x19, 0x5a, 0x5a, 0xb9, 0x62, 0x14, 0x78, 0x3e, 0x0d,
  0xf1, 0x87, 0xcc, 0x75, 0xc1, 0xb8, 0x14, 0xca, 0x5e, 0x4b, 0xde, 0x9e,
  0xc7, 0x76, 0x85, 0xa2, 0x5d, 0x28, 0x62, 0x7c, 0x5c, 0x51, 0x96, 0xab,
  0x4f, 0x7e, 0xbf, 0x67, 0xba, 0xa6, 0xb0, 0x63, 0xbe, 0xbc, 0x9e, 0x1f,
  0xf9, 0xc5, 0x8a, 0xf5, 0xd2, 0xa5, 0x31, 0x29, 0xb1, 0x35, 0x90, 0xed,
  0xc7, 0xaf, 0x2f, 0x63, 0x8b, 0xc2, 0x47, 0x2b, 0x9a, 0x65, 0xa3, 0xd7,
  0x28, 0xe8, 0x19, 0xda, 0xbc

};

static const int deviceCertificateLength = sizeof(deviceCertificate); //689;

  #pragma once
  const static unsigned char devicePrivateKey[] = {
  
  0x30, 0x82, 0x02, 0x5d, 0x02, 0x01, 0x00, 0x02, 0x81, 0x81, 0x00, 0xc8,
  0xa8, 0x06, 0x07, 0x81, 0x24, 0xb0, 0xb6, 0x92, 0x55, 0x87, 0x12, 0x12,
  0x54, 0x50, 0x08, 0xd7, 0x39, 0xce, 0xba, 0xd1, 0xb3, 0x6d, 0xe7, 0xbb,
  0x31, 0x8a, 0x30, 0xa3, 0xb7, 0xfe, 0x1f, 0xea, 0x0d, 0xab, 0x89, 0x22,
  0xf2, 0x93, 0xc8, 0x5b, 0x48, 0xea, 0x73, 0x6f, 0x87, 0xae, 0x70, 0x1d,
  0x94, 0x1c, 0x26, 0xbe, 0x08, 0x9d, 0xb1, 0xd2, 0x7c, 0xc1, 0xe4, 0xb6,
  0x8f, 0x5e, 0xbb, 0x18, 0xe6, 0xb9, 0x19, 0x58, 0xb4, 0xcf, 0x06, 0x6f,
  0x3f, 0x35, 0x0a, 0x0f, 0x94, 0x82, 0x88, 0xb1, 0x1e, 0x17, 0xa5, 0x52,
  0x73, 0xa0, 0xf8, 0x6d, 0x0a, 0x17, 0x6e, 0x7a, 0x39, 0x47, 0x4c, 0x14,
  0xfd, 0xdf, 0x9d, 0x62, 0x48, 0x0f, 0x7f, 0xe9, 0x97, 0x94, 0xc0, 0xb8,
  0x8f, 0xb7, 0x76, 0xf4, 0xf0, 0x1f, 0xf1, 0xc1, 0x66, 0xbc, 0xf9, 0xf7,
  0xe3, 0xf0, 0xb7, 0x66, 0xe5, 0xeb, 0x09, 0x02, 0x03, 0x01, 0x00, 0x01,
  0x02, 0x81, 0x80, 0x09, 0xdb, 0xd7, 0x8f, 0xfe, 0xd4, 0x62, 0xaa, 0x55,
  0xbe, 0x46, 0x08, 0xa9, 0x45, 0xe3, 0x38, 0xcb, 0xfa, 0x57, 0x21, 0xee,
  0xb3, 0xb6, 0x2e, 0xb0, 0x8f, 0xda, 0x8e, 0x51, 0x3c, 0xf5, 0x0b, 0x74,
  0x60, 0x7f, 0x91, 0x19, 0x5a, 0x79, 0xd0, 0x5a, 0x4b, 0xd6, 0xd9, 0x1d,
  0x1d, 0xb9, 0x80, 0x60, 0xb3, 0xaa, 0x3e, 0x6d, 0x0f, 0xd7, 0x4f, 0xa9,
  0x5b, 0xdf, 0xda, 0xf0, 0xed, 0x52, 0x66, 0x20, 0x9f, 0xb4, 0x0d, 0x88,
  0x23, 0x7d, 0xd2, 0x5a, 0x0a, 0x39, 0x6a, 0x82, 0xd8, 0x88, 0x75, 0x62,
  0x11, 0x39, 0x6f, 0xd8, 0x36, 0xba, 0x30, 0x86, 0x15, 0x1b, 0x51, 0xee,
  0x90, 0x7d, 0x58, 0x60, 0xd5, 0xb6, 0xc9, 0xd7, 0x2d, 0x23, 0x1b, 0xa3,
  0xb5, 0x8d, 0xef, 0x5d, 0xb3, 0x4d, 0x12, 0x89, 0x20, 0xee, 0x7f, 0xec,
  0x81, 0x40, 0x97, 0xc9, 0xee, 0xb9, 0x61, 0x21, 0x5a, 0x3e, 0x51, 0x02,
  0x41, 0x00, 0xf0, 0x5b, 0x47, 0x31, 0xcb, 0xf4, 0xb3, 0x5d, 0x24, 0xd6,
  0xd1, 0xf8, 0x41, 0x9d, 0xca, 0x3d, 0xc5, 0x90, 0x6e, 0x61, 0x32, 0xe9,
  0xd0, 0x43, 0x12, 0x67, 0x70, 0x01, 0x45, 0x8d, 0xbd, 0xe3, 0x0a, 0x30,
  0x06, 0xd0, 0x0e, 0xd4, 0x75, 0xff, 0x4b, 0x1f, 0xf8, 0x2d, 0xf9, 0xe1,
  0x72, 0x60, 0xb3, 0xbd, 0x60, 0x4c, 0x3e, 0x00, 0xf1, 0x0e, 0x23, 0x19,
  0x7f, 0x5a, 0xfe, 0x61, 0x86, 0x13, 0x02, 0x41, 0x00, 0xd5, 0xb7, 0x46,
  0xdf, 0xe6, 0xfc, 0x0e, 0x79, 0xea, 0xf5, 0x4f, 0x4b, 0x58, 0x0e, 0xa0,
  0x4a, 0x15, 0x52, 0xde, 0x4a, 0x08, 0xc1, 0x46, 0xc0, 0x25, 0x14, 0x64,
  0x15, 0x9a, 0x3d, 0xd4, 0x64, 0x6a, 0xad, 0x70, 0x87, 0x86, 0x6a, 0x32,
  0x16, 0x2d, 0xcb, 0xc1, 0x12, 0x4b, 0xfb, 0xf6, 0x64, 0x4f, 0x8d, 0x17,
  0xfc, 0x68, 0xe8, 0xba, 0xfb, 0xd9, 0x5c, 0x77, 0x18, 0xc5, 0xbe, 0x9d,
  0xf3, 0x02, 0x41, 0x00, 0xbb, 0x44, 0x12, 0xcb, 0x2c, 0x82, 0x41, 0xc1,
  0x1f, 0x73, 0xb3, 0xf2, 0x3d, 0x85, 0x67, 0xce, 0x0b, 0x00, 0x85, 0xcf,
  0x7b, 0x30, 0x8a, 0x8f, 0xc7, 0x66, 0x09, 0xf1, 0x23, 0xb4, 0xd4, 0xae,
  0x71, 0x00, 0x8c, 0x3e, 0x4c, 0x5f, 0xa2, 0x73, 0xbe, 0x9f, 0x70, 0xe8,
  0xb9, 0x58, 0xba, 0x99, 0xb7, 0x50, 0xa4, 0x17, 0xa2, 0xf3, 0x6e, 0xdc,
  0xb9, 0xe2, 0x22, 0xc4, 0xcd, 0x8f, 0x44, 0x3b, 0x02, 0x41, 0x00, 0xaa,
  0x4f, 0xe3, 0x50, 0x5d, 0x60, 0x33, 0x1d, 0x1f, 0x8c, 0x1c, 0x83, 0xdb,
  0x89, 0xd4, 0x5d, 0x15, 0x7f, 0x33, 0x9c, 0x66, 0x3b, 0xb8, 0x69, 0x39,
  0x63, 0x75, 0x9a, 0xed, 0x8f, 0x26, 0x6a, 0x5b, 0xc5, 0x19, 0xef, 0x36,
  0xc3, 0xfc, 0x64, 0x46, 0x5c, 0xa0, 0xe1, 0x36, 0xe2, 0x75, 0x69, 0x5d,
  0x28, 0x00, 0x9c, 0x6a, 0xf2, 0x44, 0xc8, 0x9d, 0x60, 0x9d, 0x9c, 0x85,
  0x41, 0xb1, 0xd7, 0x02, 0x40, 0x71, 0xf2, 0xf4, 0x2f, 0x5f, 0xe7, 0x9a,
  0x81, 0x43, 0x6b, 0x37, 0xa9, 0x92, 0x29, 0x0a, 0x64, 0xaf, 0x82, 0x8a,
  0x3d, 0x6a, 0x93, 0xb6, 0xd8, 0xb3, 0xd6, 0x8c, 0xd8, 0xf3, 0x66, 0xbd,
  0x9b, 0x59, 0x86, 0x23, 0xf5, 0xae, 0xaa, 0x3c, 0xcd, 0xc2, 0xdc, 0x91,
  0x16, 0x43, 0xdd, 0xec, 0x85, 0x4b, 0x7d, 0x4f, 0xc5, 0x27, 0xb5, 0x1f,
  0x04, 0x7e, 0xb6, 0x42, 0x75, 0x0a, 0x10, 0xcb, 0x38
  
};

const static int devicePrivateKeyLength = sizeof(devicePrivateKey);

#pragma once

const static unsigned char rootCertificate[] = {
  0x30, 0x82, 0x02, 0x95, 0x30, 0x82, 0x01, 0xfe, 0xa0, 0x03, 0x02, 0x01,
  0x02, 0x02, 0x02, 0x11, 0x11, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
  0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x67, 0x31, 0x0b,
  0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x47, 0x42, 0x31,
  0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x09, 0x42, 0x65,
  0x72, 0x6b, 0x73, 0x68, 0x69, 0x72, 0x65, 0x31, 0x10, 0x30, 0x0e, 0x06,
  0x03, 0x55, 0x04, 0x07, 0x0c, 0x07, 0x4e, 0x65, 0x77, 0x62, 0x75, 0x72,
  0x79, 0x31, 0x11, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x08,
  0x56, 0x6f, 0x64, 0x61, 0x66, 0x6f, 0x6e, 0x65, 0x31, 0x0c, 0x30, 0x0a,
  0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x03, 0x52, 0x26, 0x44, 0x31, 0x11,
  0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x08, 0x44, 0x4d, 0x53,
  0x65, 0x72, 0x76, 0x65, 0x72, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x33, 0x30,
  0x39, 0x30, 0x33, 0x31, 0x34, 0x30, 0x36, 0x30, 0x38, 0x5a, 0x17, 0x0d,
  0x32, 0x33, 0x30, 0x37, 0x31, 0x33, 0x31, 0x34, 0x30, 0x36, 0x30, 0x38,
  0x5a, 0x30, 0x67, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
  0x13, 0x02, 0x47, 0x42, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04,
  0x08, 0x0c, 0x09, 0x42, 0x65, 0x72, 0x6b, 0x73, 0x68, 0x69, 0x72, 0x65,
  0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x07, 0x4e,
  0x65, 0x77, 0x62, 0x75, 0x72, 0x79, 0x31, 0x11, 0x30, 0x0f, 0x06, 0x03,
  0x55, 0x04, 0x0a, 0x0c, 0x08, 0x56, 0x6f, 0x64, 0x61, 0x66, 0x6f, 0x6e,
  0x65, 0x31, 0x0c, 0x30, 0x0a, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x03,
  0x52, 0x26, 0x44, 0x31, 0x11, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x0c, 0x08, 0x44, 0x4d, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x30, 0x81,
  0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
  0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02,
  0x81, 0x81, 0x00, 0xba, 0x95, 0x99, 0x1e, 0x6e, 0x75, 0x45, 0xb3, 0x24,
  0x12, 0x4b, 0xca, 0x02, 0xf8, 0x25, 0x33, 0xde, 0x81, 0x71, 0x65, 0x52,
  0x73, 0x15, 0xbb, 0x29, 0xa5, 0xc5, 0x86, 0x6d, 0x40, 0xae, 0xdb, 0x75,
  0xd5, 0x59, 0xb9, 0x29, 0x30, 0xb4, 0xac, 0x8f, 0xb4, 0x92, 0x21, 0xb9,
  0xe2, 0x4c, 0x61, 0xbd, 0x8e, 0xde, 0xb9, 0x67, 0x94, 0x71, 0x0a, 0x89,
  0x28, 0x7c, 0x54, 0x4c, 0x58, 0xd4, 0x5a, 0xff, 0x13, 0x70, 0x9a, 0xf3,
  0x9a, 0x32, 0x1e, 0xe4, 0x4b, 0x61, 0x8a, 0x92, 0xe9, 0x74, 0xdf, 0x95,
  0xfc, 0xf2, 0x42, 0x3b, 0xf1, 0x62, 0x2d, 0x74, 0xa2, 0xca, 0x44, 0x2c,
  0x0b, 0xe5, 0x61, 0xc9, 0x4f, 0x01, 0x28, 0xd6, 0x2b, 0xa6, 0xca, 0x72,
  0x89, 0x0d, 0x74, 0xf4, 0xa3, 0xe8, 0xc9, 0xb1, 0xfc, 0x90, 0xae, 0xd6,
  0xd8, 0x85, 0xdf, 0xd9, 0xdf, 0x40, 0x68, 0xba, 0xf3, 0x72, 0x05, 0x02,
  0x03, 0x01, 0x00, 0x01, 0xa3, 0x50, 0x30, 0x4e, 0x30, 0x1d, 0x06, 0x03,
  0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xaa, 0x27, 0x1a, 0x6f, 0x88,
  0x72, 0x8c, 0x2d, 0x2d, 0xc2, 0x5a, 0xc5, 0x74, 0x82, 0xa5, 0x44, 0xd1,
  0x3d, 0xa3, 0x15, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18,
  0x30, 0x16, 0x80, 0x14, 0xaa, 0x27, 0x1a, 0x6f, 0x88, 0x72, 0x8c, 0x2d,
  0x2d, 0xc2, 0x5a, 0xc5, 0x74, 0x82, 0xa5, 0x44, 0xd1, 0x3d, 0xa3, 0x15,
  0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x04, 0x05, 0x30, 0x03, 0x01,
  0x01, 0xff, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
  0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x7d, 0x38, 0x65,
  0xbb, 0x6b, 0xbb, 0xde, 0x19, 0xb7, 0xaa, 0xe6, 0x49, 0x5f, 0x9e, 0xe3,
  0xa0, 0xc4, 0x67, 0xfc, 0xdf, 0xa5, 0xd8, 0xa6, 0x38, 0xab, 0x5e, 0x98,
  0x23, 0xe8, 0x19, 0x22, 0x82, 0x65, 0x2c, 0x5f, 0xee, 0x21, 0x9c, 0x3a,
  0xe0, 0xeb, 0xb1, 0x7c, 0xa3, 0x5f, 0x22, 0xf2, 0xaf, 0x08, 0xbe, 0x78,
  0x2d, 0x0f, 0xbf, 0xa6, 0x58, 0x7e, 0xf0, 0x2c, 0xec, 0x99, 0x97, 0x63,
  0x75, 0x5f, 0x52, 0xff, 0x5f, 0x89, 0x79, 0xf7, 0xbe, 0x46, 0x11, 0x28,
  0x82, 0x34, 0xaf, 0x16, 0x3b, 0x36, 0xa3, 0x25, 0x5a, 0x30, 0x28, 0xd9,
  0x3b, 0x15, 0xae, 0x8e, 0xf6, 0x49, 0xdd, 0x77, 0x61, 0xa5, 0x76, 0x49,
  0xb1, 0xd9, 0xc4, 0xc7, 0x8a, 0xe0, 0x98, 0x78, 0xa3, 0xdd, 0xeb, 0x37,
  0x4b, 0x36, 0xab, 0x4d, 0x28, 0xcf, 0x55, 0x6f, 0x0c, 0xa4, 0x15, 0x38,
  0x1f, 0xc3, 0x4a, 0x95, 0x62
};

static const int rootCertificateLength = sizeof(rootCertificate);


static int receiveFunc(CYASSL* ssl, char *buf, int sz, void *ctx)
{    
    int fd = *(int*)ctx;
    fd_set rfds;
    FD_ZERO(&rfds);
    FD_SET(fd, &rfds);
    
    int ret = lwip_select(FD_SETSIZE, &rfds, NULL, NULL, NULL);
    if(ret <= 0 || !FD_ISSET(fd, &rfds))
        return -1;   
    return lwip_recv(fd, buf, sz, 0);
}

static int sendFunc(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int fd = *(int*)ctx;
    fd_set wfds;
    FD_ZERO(&wfds);
    FD_SET(fd, &wfds);
    
    int ret = lwip_select(FD_SETSIZE, NULL, &wfds, NULL, NULL);
    if(ret <= 0 || !FD_ISSET(fd, &wfds))
        return -1;   
            
    return lwip_send(fd, buf, sz, 0);    
}

const static int HTTPS_PORT = 443;

TLSServer::TLSServer():
_ssl_ctx(NULL)
{
}

TLSServer::~TLSServer()
{
    
}

bool TLSServer::init()
{
    if (init_socket(SOCK_STREAM) < 0)
        return false;
    
    struct sockaddr_in localHost;
    memset(&localHost, 0, sizeof(localHost));
    
    localHost.sin_family = AF_INET;
    localHost.sin_port = htons(HTTPS_PORT);
    localHost.sin_addr.s_addr = INADDR_ANY;
    
    if (lwip_bind(_sock_fd, (const struct sockaddr *) &localHost, sizeof(localHost)) < 0) {
        close();
        return false;
    }
    if (lwip_listen(_sock_fd, 4) < 0) {
        close();
        return false;
    }
    
    CyaSSL_Init();

    CYASSL_METHOD* method = CyaTLSv1_server_method();
    if(method == NULL)
        return false;

    _ssl_ctx = CyaSSL_CTX_new(method);
    if(_ssl_ctx == NULL)
        return false;
    
    CyaSSL_SetIOSend(_ssl_ctx, &sendFunc);
    CyaSSL_SetIORecv(_ssl_ctx, &receiveFunc);
    CyaSSL_CTX_load_verify_buffer(_ssl_ctx,rootCertificate, rootCertificateLength,SSL_FILETYPE_ASN1);
    CyaSSL_CTX_use_certificate_buffer(_ssl_ctx, deviceCertificate, deviceCertificateLength, SSL_FILETYPE_ASN1);
    CyaSSL_CTX_use_PrivateKey_buffer(_ssl_ctx, devicePrivateKey, devicePrivateKeyLength, SSL_FILETYPE_ASN1);
    

    return true;
}

bool TLSServer::accept(TLSConnection &con)
{
    if(_ssl_ctx == NULL)
        return false;
        
    fd_set fdSet;
    FD_ZERO(&fdSet);
    FD_SET(_sock_fd, &fdSet);
    
    
    int ret = lwip_select(FD_SETSIZE, &fdSet, NULL, NULL, NULL);
    if(ret <= 0 || !FD_ISSET(_sock_fd, &fdSet))
        return -1;   
                
    con.reset_address();
    socklen_t newSockRemoteHostLen = sizeof(con._remoteHost);
    int fd = lwip_accept(_sock_fd, (struct sockaddr*) &con._remoteHost, &newSockRemoteHostLen);
    if (fd < 0)
        return false;
    con._sock_fd = fd;
    
    con._ssl_ctx = _ssl_ctx;
    con._ssl = CyaSSL_new(_ssl_ctx);
    if(con._ssl == NULL)
        return false;
    CyaSSL_set_fd(con._ssl, fd);
    if(CyaSSL_accept(con._ssl) < 0)
    {
        CyaSSL_free(con._ssl);
        return false;
    }

    con._is_connected = true;
    return true;
}

